<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<?php
// Get extension details
$extension_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$sql = "SELECT pe.*, 
               u_created.full_name as created_by_name,
               u_updated.full_name as updated_by_name
        FROM passport_extensions pe
        LEFT JOIN users u_created ON pe.created_by = u_created.user_id
        LEFT JOIN users u_updated ON pe.updated_by = u_updated.user_id
        WHERE pe.extension_id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $extension_id);
$stmt->execute();
$result = $stmt->get_result();

if (!$result->num_rows) {
    header("Location: list_extensions.php");
    exit;
}

$extension = $result->fetch_assoc();
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'View Extension Details')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Extensions', 'title' => 'View Extension Details')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header d-flex align-items-center">
                                    <h5 class="card-title mb-0 flex-grow-1">Extension Details</h5>
                                    <div>
                                        <a href="print_extension.php?id=<?php echo $extension_id; ?>" 
                                           class="btn btn-primary me-2">
                                            <i class="ri-printer-line align-middle me-1"></i> Print
                                        </a>
                                        <a href="all_extensions.php" class="btn btn-secondary">
                                            <i class="ri-arrow-left-line align-middle me-1"></i> Back to List
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <!-- Client Information -->
                                        <div class="col-lg-6">
                                            <div class="card border">
                                                <div class="card-header bg-soft-primary">
                                                    <h5 class="card-title mb-0">Client Information</h5>
                                                </div>
                                                <div class="card-body">
                                                    <table class="table table-borderless mb-0">
                                                        <tr>
                                                            <th width="35%">Client Name:</th>
                                                            <td><?php echo htmlspecialchars($extension['client_name']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Passport Number:</th>
                                                            <td><?php echo htmlspecialchars($extension['passport_number']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Country of Issue:</th>
                                                            <td><?php echo htmlspecialchars($extension['country_of_issue']); ?></td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Service Details -->
                                        <div class="col-lg-6">
                                            <div class="card border">
                                                <div class="card-header bg-soft-success">
                                                    <h5 class="card-title mb-0">Service Details</h5>
                                                </div>
                                                <div class="card-body">
                                                    <table class="table table-borderless mb-0">
                                                        <tr>
                                                            <th width="35%">Service Type:</th>
                                                            <td><span class="badge bg-primary"><?php echo ucfirst($extension['service_type']); ?></span></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Extension Date:</th>
                                                            <td><?php echo date('d M Y', strtotime($extension['extension_date'])); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Validity Period:</th>
                                                            <td><?php echo $extension['validity_period']; ?> months</td>
                                                        </tr>
                                                        <tr>
                                                            <th>Expiry Date:</th>
                                                            <td><?php echo date('d M Y', strtotime($extension['expiry_date'])); ?></td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Payment Information -->
                                        <div class="col-lg-6">
                                            <div class="card border">
                                                <div class="card-header bg-soft-info">
                                                    <h5 class="card-title mb-0">Payment Information</h5>
                                                </div>
                                                <div class="card-body">
                                                    <table class="table table-borderless mb-0">
                                                        <tr>
                                                            <th width="35%">Currency:</th>
                                                            <td><?php echo $extension['currency']; ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Amount Received:</th>
                                                            <td><?php echo $extension['currency'] . " " . number_format($extension['amount_received'], 2); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Service Payment:</th>
                                                            <td><?php echo $extension['currency'] . " " . number_format($extension['service_payment'], 2); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Agency Fee:</th>
                                                            <td><?php echo $extension['currency'] . " " . number_format($extension['agency_fee'], 2); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Payment Status:</th>
                                                            <td>
                                                                <?php
                                                                $statusClass = [
                                                                    'paid' => 'bg-success',
                                                                    'unpaid' => 'bg-danger',
                                                                    'partial' => 'bg-warning'
                                                                ][$extension['payment_status']];
                                                                ?>
                                                                <span class="badge <?php echo $statusClass; ?>">
                                                                    <?php echo ucfirst($extension['payment_status']); ?>
                                                                </span>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Additional Information -->
                                        <div class="col-lg-6">
                                            <div class="card border">
                                                <div class="card-header bg-soft-warning">
                                                    <h5 class="card-title mb-0">Additional Information</h5>
                                                </div>
                                                <div class="card-body">
                                                    <table class="table table-borderless mb-0">
                                                        <tr>
                                                            <th width="35%">Notes:</th>
                                                            <td><?php echo nl2br(htmlspecialchars($extension['notes'] ?? '')); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Created By:</th>
                                                            <td><?php echo htmlspecialchars($extension['created_by_name']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Created At:</th>
                                                            <td><?php echo date('d M Y H:i', strtotime($extension['created_at'])); ?></td>
                                                        </tr>
                                                        <?php if ($extension['updated_by']): ?>
                                                        <tr>
                                                            <th>Last Updated By:</th>
                                                            <td><?php echo htmlspecialchars($extension['updated_by_name']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Last Updated At:</th>
                                                            <td><?php echo date('d M Y H:i', strtotime($extension['updated_at'])); ?></td>
                                                        </tr>
                                                        <?php endif; ?>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
</body>
</html>