<?php
include 'layouts/session.php';
include 'layouts/dbconn.php';

header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $conn->begin_transaction();
    try {
        if (!isset($_POST['application_id'])) {
            throw new Exception("Application ID is required");
        }

        $applicationId = intval($_POST['application_id']);

        // Verify application exists and is editable
        $checkStmt = $conn->prepare("SELECT status FROM visa_applications WHERE application_id = ?");
        $checkStmt->bind_param("i", $applicationId);
        $checkStmt->execute();
        $result = $checkStmt->get_result();
        if ($result->num_rows === 0) {
            throw new Exception("Application not found");
        }
        $currentStatus = $result->fetch_assoc()['status'];
        if (!in_array($currentStatus, ['Submitted', 'Under Review'])) {
            throw new Exception("This application cannot be edited in its current status");
        }

        // Handle file uploads
        $uploadDir = 'uploads/visa_documents/';
        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }

        $updateFields = [];
        $types = "";
        $params = [];

        // Process passport copy
        if (isset($_FILES['passport_copy']) && $_FILES['passport_copy']['error'] == 0) {
            $passportCopyPath = $uploadDir . uniqid() . '_' . basename($_FILES['passport_copy']['name']);
            move_uploaded_file($_FILES['passport_copy']['tmp_name'], $passportCopyPath);
            $updateFields[] = "passport_copy_path = ?";
            $types .= "s";
            $params[] = $passportCopyPath;
        }

        // Process photo
        if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
            $photoPath = $uploadDir . uniqid() . '_' . basename($_FILES['photo']['name']);
            move_uploaded_file($_FILES['photo']['tmp_name'], $photoPath);
            $updateFields[] = "photo_path = ?";
            $types .= "s";
            $params[] = $photoPath;
        }

        // Process insurance proof
        if (isset($_FILES['travel_insurance_proof']) && $_FILES['travel_insurance_proof']['error'] == 0) {
            $insurancePath = $uploadDir . uniqid() . '_' . basename($_FILES['travel_insurance_proof']['name']);
            move_uploaded_file($_FILES['travel_insurance_proof']['tmp_name'], $insurancePath);
            $updateFields[] = "travel_insurance_proof_path = ?";
            $types .= "s";
            $params[] = $insurancePath;
        }

        // Add other fields to update
        $fields = [
            'first_name' => 's',
            'last_name' => 's',
            'nationality' => 's',
            'destination_country' => 's',
            'application_type' => 's',
            'status' => 's',
            'date_of_birth' => 's',
            'gender' => 's',
            'email' => 's',
            'phone_number' => 's',
            'intended_arrival_date' => 's',
            'intended_departure_date' => 's',
            'monthly_income' => 'd',
            'total_trip_cost' => 'd',
            'processing_fee' => 'd',
            'assigned_agent_id' => 'i',
            'entry_type' => 's',
            'passport_number' => 's'
        ];

        foreach ($fields as $field => $type) {
            if (isset($_POST[$field]) && !empty($_POST[$field])) {
                $updateFields[] = "$field = ?";
                $types .= $type;
                $params[] = $_POST[$field];
            }
        }

        $updateFields[] = "updated_by = ?";
        $types .= "i";
        $params[] = $_SESSION['user_id'];

        // Add application_id to parameters
        $types .= "i";
        $params[] = $applicationId;

        $sql = "UPDATE visa_applications SET " . implode(", ", $updateFields) . " WHERE application_id = ?";
        $stmt = $conn->prepare($sql);

        if (!empty($params)) {
            $stmt->bind_param($types, ...$params);
            if (!$stmt->execute()) {
                throw new Exception("Error updating application: " . $stmt->error);
            }
        }

        $conn->commit();

        echo json_encode([
            'status' => 'success',
            'message' => 'Visa application updated successfully!',
            'application_id' => $applicationId
        ]);

    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode([
            'status' => 'error',
            'message' => $e->getMessage()
        ]);
    }
}

$conn->close();
?>