<?php
// Include the database connection file
include 'layouts/dbconn.php';

// Initialize a variable to hold the status message
$status = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Retrieve form values
    $flight_number = $_POST['flightNumber'];
    $origin_id = $_POST['originId'];
    $destination_id = $_POST['destinationId'];
    $departure_time = $_POST['departureTime'];
    $arrival_time = $_POST['arrivalTime'];
    $start_date = $_POST['startDate'];
    $end_date = $_POST['endDate'];

    // Retrieve days of operation
    $days_of_week = [];
    if (!empty($_POST['daysOfWeek'])) {
        $days_of_week = $_POST['daysOfWeek'];
    }

    // Prepare the days of the week as a string for storage
    $days_string = implode(',', $days_of_week);

    // SQL query to insert data into the `flight_schedules` table
    $sql = "INSERT INTO flight_schedules (flight_number, origin_id, destination_id, departure_time, arrival_time, days_of_week, start_date, end_date)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

    // Prepare the statement
    $stmt = $conn->prepare($sql);

    // Bind parameters
    $stmt->bind_param("siisssss", $flight_number, $origin_id, $destination_id, $departure_time, $arrival_time, $days_string, $start_date, $end_date);

    // Execute the statement
    if ($stmt->execute()) {
        // If the query is successful, set the status message to success
        $status = "success";
    } else {
        // If the query fails, set the status message to error
        $status = "error";
    }

    // Close the statement and database connection
    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Flight Schedule Management</title>
    <!-- SweetAlert2 library -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>
<?php if ($status === "success"): ?>
    <script>
        Swal.fire({
            title: 'Success!',
            text: 'Flight schedule saved successfully.',
            icon: 'success',
            confirmButtonText: 'OK'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = 'all_flight_schedules.php'; // Redirect to the flight schedules list page or any other page
            }
        });
    </script>
<?php elseif ($status === "error"): ?>
    <script>
        Swal.fire({
            title: 'Error!',
            text: 'Failed to save the flight schedule. Please try again.',
            icon: 'error',
            confirmButtonText: 'OK'
        }).then((result) => {
            if (result.isConfirmed) {
                window.history.back(); // Go back to the form or stay on the same page
            }
        });
    </script>
<?php endif; ?>
</body>
</html>