<?php 
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';

$id = $_GET['id'];
$query = "SELECT * FROM expenses WHERE expense_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$expense = $result->fetch_assoc();
?>

<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable">

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Edit Expense')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Expense Management', 'title' => 'Edit Expense')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Edit Expense</h4>
                                </div>
                                <div class="card-body">
                                    <form id="editExpenseForm" method="POST" action="update_expense.php">
                                        <input type="hidden" name="expense_id" value="<?php echo $expense['expense_id']; ?>">
                                        <div class="row gy-4">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="expense_type" class="form-label">Expense Type</label>
                                                    <select class="form-select" id="expense_type" name="expense_type" required>
                                                        <?php
                                                        $types = ['fuel', 'maintenance', 'repairs', 'insurance', 'licenses', 'salaries', 
                                                                'rent', 'utilities', 'office_supplies', 'travel', 'marketing', 'other'];
                                                        foreach($types as $type):
                                                            $selected = ($expense['expense_type'] == $type) ? 'selected' : '';
                                                            echo "<option value='$type' $selected>" . ucfirst(str_replace('_', ' ', $type)) . "</option>";
                                                        endforeach;
                                                        ?>
                                                    </select>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="amount" class="form-label">Amount</label>
                                                    <input type="number" step="0.01" class="form-control" id="amount" name="amount" 
                                                           value="<?php echo $expense['amount']; ?>" required>
                                                           </div>
                                                <div class="mb-3">
                                                    <label for="currency" class="form-label">Currency</label>
                                                    <select class="form-select" id="currency" name="currency" required>
                                                        <option value="KES" <?php echo $expense['currency'] == 'KES' ? 'selected' : ''; ?>>KES</option>
                                                        <option value="USD" <?php echo $expense['currency'] == 'USD' ? 'selected' : ''; ?>>USD</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="expense_date" class="form-label">Expense Date</label>
                                                    <input type="date" class="form-control" id="expense_date" name="expense_date" 
                                                           value="<?php echo $expense['expense_date']; ?>" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="payment_method" class="form-label">Payment Method</label>
                                                    <select class="form-select" id="payment_method" name="payment_method" required>
                                                        <?php
                                                        $methods = ['cash', 'bank_transfer', 'mobile_money', 'credit_card', 'check'];
                                                        foreach($methods as $method):
                                                            $selected = ($expense['payment_method'] == $method) ? 'selected' : '';
                                                            echo "<option value='$method' $selected>" . ucfirst(str_replace('_', ' ', $method)) . "</option>";
                                                        endforeach;
                                                        ?>
                                                    </select>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="reference_number" class="form-label">Reference Number</label>
                                                    <input type="text" class="form-control" id="reference_number" name="reference_number" 
                                                           value="<?php echo $expense['reference_number']; ?>">
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="mb-3">
                                                    <label for="description" class="form-label">Description</label>
                                                    <textarea class="form-control" id="description" name="description" rows="3"><?php echo $expense['description']; ?></textarea>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <button type="submit" class="btn btn-primary">Update Expense</button>
                                                <a href="expenses.php" class="btn btn-secondary">Cancel</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>

</body>
</html>