<?php
include 'layouts/session.php';
include 'layouts/dbconn.php';

if (isset($_GET['id'])) {
    $customer_id = intval($_GET['id']);
    
    try {
        // Start transaction
        $conn->begin_transaction();
        
        // First delete all addresses for this customer
        $stmt = $conn->prepare("DELETE FROM customer_addresses WHERE customer_id = ?");
        $stmt->bind_param("i", $customer_id);
        $stmt->execute();
        
        // Then delete the customer
        $stmt = $conn->prepare("DELETE FROM customers WHERE customer_id = ?");
        $stmt->bind_param("i", $customer_id);
        $stmt->execute();
        
        // If we got here, commit the transaction
        $conn->commit();
        
        $_SESSION['success_msg'] = "Customer deleted successfully";
    } catch (Exception $e) {
        // An error occurred, rollback the transaction
        $conn->rollback();
        $_SESSION['error_msg'] = "Error deleting customer: " . $e->getMessage();
    }
} else {
    $_SESSION['error_msg'] = "Invalid customer ID";
}

// Redirect back to customers list
header("Location: all_customers.php");
exit();
?>