<?php
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';

// Fetch dashboard data
$sql = "SELECT 
    COUNT(CASE WHEN DATE(created_date) = CURDATE() THEN 1 END) as today_tickets,
    COUNT(CASE WHEN status = 'Active' THEN 1 END) as active_tickets,
    SUM(ticket_cost) as total_revenue,
    AVG(agency_fee) as avg_fee
FROM ticket_details
WHERE created_date >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)";

$dashboardStats = $conn->query($sql)->fetch_assoc();

// Get upcoming flights
$upcomingFlights = $conn->query("
    SELECT COUNT(*) as count 
    FROM flight_schedules 
    WHERE departure_time BETWEEN NOW() AND DATE_ADD(NOW(), INTERVAL 24 HOUR)
")->fetch_assoc()['count'];

// Get recent tickets
$recentTickets = $conn->query("
    SELECT td.*, 
           CONCAT(td.salutation, ' ', td.customer_name) as customer_name
    FROM ticket_details td
    ORDER BY created_date DESC 
    LIMIT 10
");

// Get recent visa applications
$recentVisas = $conn->query("
    SELECT * FROM visa_applications 
    ORDER BY created_at DESC 
    LIMIT 5
");

// Get recent cargo bookings
$recentCargo = $conn->query("
    SELECT cb.*, 
           CONCAT(c.first_name, ' ', c.last_name) as sender_name,
           rc.first_name as receiver_name
    FROM cargo_bookings cb
    LEFT JOIN customers c ON cb.sender_customer_id = c.customer_id
    LEFT JOIN customers rc ON cb.receiver_customer_id = rc.customer_id
    ORDER BY booking_date DESC 
    LIMIT 5
");

// Weather alerts function
function getWeatherAlerts() {
    $cities = ['Nairobi', 'Juba', 'Mogadishu', 'Dubai'];
    $alerts = [];
    foreach ($cities as $city) {
        $conditions = ['Clear', 'Rain', 'Storm', 'Heat'];
        $condition = $conditions[array_rand($conditions)];
        if ($condition !== 'Clear') {
            $alerts[] = [
                'location' => $city,
                'alert' => $condition,
                'severity' => ($condition === 'Storm' ? 'high' : 'medium')
            ];
        }
    }
    return $alerts;
}

$weatherAlerts = getWeatherAlerts();
?>

<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable">

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Dashboard')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Dashboard', 'title' => 'Welcome')); ?>

                    <!-- Performance Metrics Row -->
                    <div class="row">
                        <!-- Today's Tickets Card -->
                        <div class="col-xl-3">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-grow-1">
                                            <h6 class="text-muted mb-3">Today's Tickets</h6>
                                            <h2 class="mb-0">
                                                <span class="counter-value" data-target="<?php echo $dashboardStats['today_tickets']; ?>">
                                                    <?php echo $dashboardStats['today_tickets']; ?>
                                                </span>
                                            </h2>
                                        </div>
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-primary-subtle text-primary rounded fs-3">
                                                <i class="ri-ticket-2-line"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Active Tickets Card -->
                        <div class="col-xl-3">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-grow-1">
                                            <h6 class="text-muted mb-3">Active Tickets</h6>
                                            <h2 class="mb-0">
                                                <span class="counter-value" data-target="<?php echo $dashboardStats['active_tickets']; ?>">
                                                    <?php echo $dashboardStats['active_tickets']; ?>
                                                </span>
                                            </h2>
                                        </div>
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-success-subtle text-success rounded fs-3">
                                                <i class="ri-checkbox-circle-line"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Revenue Card -->
                        <div class="col-xl-3">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-grow-1">
                                            <h6 class="text-muted mb-3">Total Revenue (30d)</h6>
                                            <h2 class="mb-0">
                                                $<?php echo number_format($dashboardStats['total_revenue'], 2); ?>
                                            </h2>
                                        </div>
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-info-subtle text-info rounded fs-3">
                                                <i class="ri-money-dollar-circle-line"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Weather Alerts Card -->
                        <div class="col-xl-3">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-grow-1">
                                            <h6 class="text-muted mb-3">Weather Updates</h6>
                                            <div class="weather-alerts" style="max-height: 150px; overflow-y: auto;">
                                                <?php foreach ($weatherAlerts as $alert): ?>
                                                    <div class="d-flex align-items-center mb-2">
                                                        <span class="badge bg-<?php echo $alert['severity'] === 'high' ? 'danger' : 'warning'; ?> me-2">
                                                            <?php echo htmlspecialchars($alert['location']); ?>
                                                        </span>
                                                        <small><?php echo htmlspecialchars($alert['alert']); ?></small>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                        </div>
                                        <div class="avatar-sm flex-shrink-0">
                                            <span class="avatar-title bg-warning-subtle text-warning rounded fs-3">
                                                <i class="ri-cloud-line"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Recent Activities -->
                    <div class="row">
                        <!-- Recent Tickets -->
                        <div class="col-xl-8">
                            <div class="card">
                                <div class="card-header d-flex align-items-center">
                                    <h5 class="card-title mb-0 flex-grow-1">Recent Tickets</h5>
                                    <a href="all_new_tickets.php" class="btn btn-primary btn-sm">
                                        <i class="ri-eye-line align-middle me-1"></i> View All
                                    </a>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-hover table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Reference</th>
                                                    <th>Customer</th>
                                                    <th>Route</th>
                                                    <th>Date</th>
                                                    <th>Amount</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php while($ticket = $recentTickets->fetch_assoc()): ?>
                                                    <tr>
                                                        <td><?php echo htmlspecialchars($ticket['ticket_ref']); ?></td>
                                                        <td><?php echo htmlspecialchars($ticket['customer_name']); ?></td>
                                                        <td><?php echo htmlspecialchars($ticket['flight_route']); ?></td>
                                                        <td><?php echo date('d M Y', strtotime($ticket['flight_date'])); ?></td>
                                                        <td>$<?php echo number_format($ticket['total_amount'], 2); ?></td>
                                                        <td>
                                                            <span class="badge bg-<?php echo $ticket['status'] === 'Active' ? 'success' : 
                                                                ($ticket['status'] === 'Used' ? 'info' : 'danger'); ?>">
                                                                <?php echo htmlspecialchars($ticket['status']); ?>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                <?php endwhile; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Recent Visas -->
                        <div class="col-xl-4">
                            <div class="card">
                                <div class="card-header d-flex align-items-center">
                                    <h5 class="card-title mb-0 flex-grow-1">Recent Visa Applications</h5>
                                    <a href="all_visas.php" class="btn btn-primary btn-sm">
                                        <i class="ri-eye-line align-middle me-1"></i> View All
                                    </a>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Reference</th>
                                                    <th>Type</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php while($visa = $recentVisas->fetch_assoc()): ?>
                                                    <tr>
                                                        <td><?php echo htmlspecialchars($visa['passport_number']); ?></td>
                                                        <td><?php echo htmlspecialchars($visa['application_type']); ?></td>
                                                        <td>
                                                            <span class="badge bg-<?php echo 
                                                                $visa['status'] === 'Approved' ? 'success' : 
                                                                ($visa['status'] === 'Pending' ? 'warning' : 'info'); ?>">
                                                                <?php echo htmlspecialchars($visa['status']); ?>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                <?php endwhile; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        
                    </div>
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header d-flex align-items-center">
                                    <h5 class="card-title mb-0 flex-grow-1">Recent Cargo Bookings</h5>
                                    <a href="all_cargo.php" class="btn btn-primary btn-sm">
                                        <i class="ri-eye-line align-middle me-1"></i> View All
                                    </a>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-hover table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Booking Number</th>
                                                    <th>Sender</th>
                                                    <th>Receiver</th>
                                                    <th>Type</th>
                                                    <th>Weight</th>
                                                    <th>Amount</th>
                                                    <th>Status</th>
                                                    <th>Delivery Date</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php while($cargo = $recentCargo->fetch_assoc()): ?>
                                                    <tr>
                                                        <td>
                                                            <a href="cargo_view.php?booking_number=<?php echo $cargo['booking_number']; ?>" 
                                                               class="fw-medium">
                                                                <?php echo htmlspecialchars($cargo['booking_number']); ?>
                                                            </a>
                                                        </td>
                                                        <td><?php echo htmlspecialchars($cargo['sender_name']); ?></td>
                                                        <td><?php echo htmlspecialchars($cargo['receiver_name']); ?></td>
                                                        <td><?php echo htmlspecialchars($cargo['cargo_type']); ?></td>
                                                        <td><?php echo $cargo['weight'] . ' kg'; ?></td>
                                                        <td><?php echo $cargo['currency'] . ' ' . number_format($cargo['total_amount'], 2); ?></td>
                                                        <td>
                                                            <span class="badge bg-<?php
                                                            switch($cargo['booking_status']) {
                                                                case 'delivered':
                                                                    echo 'success';
                                                                    break;
                                                                case 'in_transit':
                                                                    echo 'info';
                                                                    break;
                                                                case 'pending':
                                                                    echo 'warning';
                                                                    break;
                                                                case 'cancelled':
                                                                    echo 'danger';
                                                                    break;
                                                                default:
                                                                    echo 'secondary';
                                                            }
                                                            ?>">
                                                                <?php echo ucwords(str_replace('_', ' ', $cargo['booking_status'])); ?>
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <?php 
                                                            if ($cargo['actual_delivery_date']) {
                                                                echo date('d M Y', strtotime($cargo['actual_delivery_date']));
                                                            } else {
                                                                echo date('d M Y', strtotime($cargo['estimated_delivery_date'])) . ' (Est.)';
                                                            }
                                                            ?>
                                                        </td>
                                                    </tr>
                                                <?php endwhile; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>
    <script src="assets/js/app.js"></script>
</body>
</html>