<?php
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';
?>
<?php
$customer_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch customer details with addresses
$query = "SELECT c.*, 
          GROUP_CONCAT(
            CONCAT(
                ca.address_type, '|',
                ca.street_address, '|',
                ca.city, '|',
                ca.state, '|',
                ca.postal_code, '|',
                ca.country, '|',
                ca.is_default
            ) SEPARATOR '##'
          ) as addresses
          FROM customers c
          LEFT JOIN customer_addresses ca ON c.customer_id = ca.customer_id
          WHERE c.customer_id = ?
          GROUP BY c.customer_id";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $customer_id);
$stmt->execute();
$result = $stmt->get_result();
$customer = $result->fetch_assoc();

// Parse addresses
$addresses = [];
if (!empty($customer['addresses'])) {
    $addr_array = explode('##', $customer['addresses']);
    foreach ($addr_array as $addr) {
        list($type, $street, $city, $state, $postal, $country, $is_default) = explode('|', $addr);
        $addresses[] = [
            'type' => $type,
            'street' => $street,
            'city' => $city,
            'state' => $state,
            'postal' => $postal,
            'country' => $country,
            'is_default' => $is_default
        ];
    }
}
?>
<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Customer Profile')); ?>

    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">

    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Customers Management', 'title' => 'Customer Profile')); ?>

                    <div class="row">
                        <div class="col-xxl-3">
                            <div class="card">
                                <div class="card-body">
                                    <div class="text-center">
                                        <h4 class="mb-1"><?php echo htmlspecialchars($customer['first_name'] . ' ' . $customer['last_name']); ?></h4>
                                        <p class="text-muted">Customer ID: <?php echo $customer['customer_id']; ?></p>
                                        <div class="mt-4">
                                            <a href="edit_customer.php?id=<?php echo $customer_id; ?>" class="btn btn-primary btn-sm">
                                                <i class="ri-edit-box-line align-bottom"></i> Edit Profile
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Contact Info Card -->
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Contact Info</h5>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <p class="text-muted text-uppercase fw-semibold mb-1"><i class="ri-mail-line me-1"></i> Email</p>
                                        <h6><?php echo htmlspecialchars($customer['email']); ?></h6>
                                    </div>
                                    <div class="mb-3">
                                        <p class="text-muted text-uppercase fw-semibold mb-1"><i class="ri-phone-line me-1"></i> Phone</p>
                                        <h6><?php echo htmlspecialchars($customer['phone_number']); ?></h6>
                                    </div>
                                    <?php if (!empty($customer['passport'])): ?>
                                    <div>
                                        <p class="text-muted text-uppercase fw-semibold mb-1"><i class="ri-passport-line me-1"></i> Passport</p>
                                        <h6><?php echo htmlspecialchars($customer['passport']); ?></h6>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-xxl-9">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Registered Addresses</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <?php foreach ($addresses as $address): ?>
                                        <div class="col-md-6 mb-3">
                                            <div class="card border">
                                                <div class="card-body">
                                                    <div class="float-end">
                                                        <?php if ($address['is_default'] == 1): ?>
                                                        <span class="badge bg-success">Default</span>
                                                        <?php endif; ?>
                                                    </div>
                                                    <h5 class="mb-3 text-uppercase"><?php echo ucfirst($address['type']); ?> Address</h5>
                                                    <p class="mb-2"><?php echo htmlspecialchars($address['street']); ?></p>
                                                    <p class="mb-2">
                                                        <?php echo htmlspecialchars($address['city']); ?>
                                                        <?php if (!empty($address['state'])): ?>, <?php echo htmlspecialchars($address['state']); ?><?php endif; ?>
                                                    </p>
                                                    <p class="mb-2"><?php echo htmlspecialchars($address['postal']); ?></p>
                                                    <p class="mb-0"><?php echo htmlspecialchars($address['country']); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Recent Orders/Activity can be added here -->
                        </div>
                    </div>
                    <!--end row-->
                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/vendor-scripts.php'; ?>

    <script src="assets/libs/list.js/list.min.js"></script>
    <script src="assets/libs/list.pagination.js/list.pagination.min.js"></script>

    <script src="assets/js/pages/crm-contact.init.js"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>


</body>
</html>
