<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<head>

    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'All Flights')); ?>

    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">


    <?php include 'layouts/head-css.php'; ?>

</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">

        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Manage Flights', 'title' => 'All Flights')); ?>


                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">All Flights</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="buttons-datatables" class="display table table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                  <th>Flight Number</th>
                                                  <th>Origin Airport</th>
                                                  <th>Destination Airport</th>
                                                  <th>Departure Time</th>
                                                  <th>Arrival Time</th>
                                                  <th>Price</th>
                                                  <th>Available Seats</th>
                                                  <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                // Include the database connection file
                                                include('layouts/dbconn.php');
                                                
                                                // Updated query to join the flights table with the airports table for origin and destination
                                                $query = "
                                                    SELECT 
                                                        f.flight_number,
                                                        o.airport_name AS origin_name,
                                                        d.airport_name AS destination_name,
                                                        f.departure_time,
                                                        f.arrival_time,
                                                        f.currency,
                                                        f.price,
                                                        f.available_seats
                                                    FROM 
                                                        flights f
                                                    JOIN 
                                                        airports o ON f.origin_id = o.airport_id
                                                    JOIN 
                                                        airports d ON f.destination_id = d.airport_id
                                                ";
                                                
                                                $result = $conn->query($query);
                                                
                                                if ($result->num_rows > 0) {
                                                    while ($row = $result->fetch_assoc()) {
                                                        echo "<tr ondblclick=\"openFileData('{$row['flight_number']}')\">"; // Assuming you want flight_number for the onclick
                                                        echo "<td>{$row['flight_number']}</td>";
                                                        echo "<td>{$row['origin_name']}</td>"; // Displaying the origin airport name
                                                        echo "<td>{$row['destination_name']}</td>"; // Displaying the destination airport name
                                                        echo "<td>{$row['departure_time']}</td>";
                                                        echo "<td>{$row['arrival_time']}</td>";
                                                        echo "<td>{$row['currency']}{$row['price']}</td>";
                                                        echo "<td>{$row['available_seats']}</td>";
                                                        echo '<td>
                                                                <div class="dropdown d-inline-block">
                                                                    <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                        <i class="ri-more-fill align-middle"></i>
                                                                    </button>
                                                                    <ul class="dropdown-menu dropdown-menu-end">
                                                                        <li><a href="flight_view.php?flight_number=' . $row['flight_number'] . '" class="dropdown-item"><i class="ri-eye-fill align-bottom me-2 text-muted"></i> View</a></li>
                                                                        <li><a class="dropdown-item edit-item-btn"><i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Edit</a></li>
                                                                        <li>
                                                                            <a class="dropdown-item remove-item-btn">
                                                                                <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> Delete
                                                                            </a>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                              </td>';    
                                                        echo "</tr>";
                                                    }
                                                } else {
                                                    echo "<tr><td colspan='8'>No flights found</td></tr>";
                                                }
                                                
                                                $conn->close(); // Close the database connection
                                                ?>
                                            </tbody>    
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!--end row-->


                    

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/vendor-scripts.php'; ?>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script src="assets/js/pages/datatables.init.js"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
</body>

</html>