<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'All Customers')); ?>

    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">

    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Customers Management', 'title' => 'All Customers')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header d-flex align-items-center justify-content-between">
                                    <h5 class="card-title mb-0">All Customers</h5>
                                    <a href="add_customer.php" class="btn btn-primary">
                                        <i class="ri-add-line align-bottom me-1"></i> Add New Customer
                                    </a>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="buttons-datatables" class="display table table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>Customer ID</th>
                                                    <th>Customer Name</th>
                                                    <th>Contact Details</th>
                                                    <th>Passport Number</th>
                                                    <th>Location</th>
                                                    <th>Created On</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $query = "SELECT c.*, 
                                                         ca.street_address, ca.city as address_city, ca.country as address_country
                                                         FROM customers c
                                                         LEFT JOIN customer_addresses ca ON c.customer_id = ca.customer_id 
                                                         AND ca.is_default = 1
                                                         ORDER BY c.created_at DESC";
                                                
                                                $result = $conn->query($query);
                                                
                                                if ($result->num_rows > 0) {
                                                    while ($row = $result->fetch_assoc()) {
                                                        echo "<tr>";
                                                        echo "<td>{$row['customer_id']}</td>";
                                                        echo "<td>
                                                                <div class='d-flex align-items-center'>
                                                                    <div class='flex-grow-1'>
                                                                        <h5 class='mb-1'>{$row['first_name']} {$row['last_name']}</h5>
                                                                    </div>
                                                                </div>
                                                              </td>";
                                                        echo "<td>
                                                                <div class='d-flex flex-column'>
                                                                    <span><i class='ri-mail-line me-1'></i>{$row['email']}</span>
                                                                    <span><i class='ri-phone-line me-1'></i>{$row['phone_number']}</span>
                                                                </div>
                                                              </td>";
                                                        echo "<td>" . ($row['passport'] ?: 'N/A') . "</td>";
                                                        echo "<td>
                                                                <div class='d-flex flex-column'>
                                                                    <span>{$row['address_city']}</span>
                                                                    <small class='text-muted'>{$row['address_country']}</small>
                                                                </div>
                                                              </td>";
                                                        echo "<td>" . date('d M Y', strtotime($row['created_at'])) . "</td>";
                                                        echo '<td>
                                                                <div class="dropdown d-inline-block">
                                                                    <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                        <i class="ri-more-fill align-middle"></i>
                                                                    </button>
                                                                    <ul class="dropdown-menu dropdown-menu-end">
                                                                        <li>
                                                                            <a href="customer_view.php?id=' . $row['customer_id'] . '" class="dropdown-item">
                                                                                <i class="ri-eye-fill align-bottom me-2 text-muted"></i> View
                                                                            </a>
                                                                        </li>
                                                                        <li>
                                                                            <a href="edit_customer.php?id=' . $row['customer_id'] . '" class="dropdown-item">
                                                                                <i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Edit
                                                                            </a>
                                                                        </li>
                                                                        <li class="dropdown-divider"></li>
                                                                        <li>
                                                                            <a href="javascript:void(0);" class="dropdown-item text-danger" 
                                                                               onclick="deleteCustomer(' . $row['customer_id'] . ')">
                                                                                <i class="ri-delete-bin-fill align-bottom me-2 text-danger"></i> Delete
                                                                            </a>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                              </td>';
                                                        echo "</tr>";
                                                    }
                                                }
                                                ?>
                                            </tbody>    
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script>
    $(document).ready(function() {
        $('#buttons-datatables').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
                'print'
            ],
            responsive: true,
            order: [[5, 'desc']], // Sort by created date by default
            pageLength: 25
        });
    });

    function deleteCustomer(customerId) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonClass: 'btn btn-primary w-xs me-2 mt-2',
            cancelButtonClass: 'btn btn-danger w-xs mt-2',
            confirmButtonText: 'Yes, delete it!',
            buttonsStyling: false,
            showCloseButton: true
        }).then(function(result) {
            if (result.value) {
                window.location.href = "delete_customer.php?id=" + customerId;
            }
        });
    }
    </script>

    <script src="assets/js/app.js"></script>
</body>
</html>