<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Add Passport Extension')); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Extensions', 'title' => 'Add Passport Extension')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Add New Passport Extension</h4>
                                </div>
                                <div class="card-body">
                                    <form id="passportExtensionForm" method="POST" action="save_passport_extension.php">
                                        <div class="live-preview">
                                            <div class="row gy-4">
                                                <!-- Client Information -->
                                                <div class="col-12">
                                                    <h5 class="text-muted mb-3">Client Information</h5>
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="extensionDate" class="form-label">Extension Date</label>
                                                        <input type="date" class="form-control" id="extensionDate" 
                                                               name="extension_date" required 
                                                               value="<?php echo date('Y-m-d'); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="clientName" class="form-label">Client Name</label>
                                                        <input type="text" class="form-control" id="clientName" 
                                                               name="client_name" required>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="passportNumber" class="form-label">Passport Number</label>
                                                        <input type="text" class="form-control" id="passportNumber" 
                                                               name="passport_number" required>
                                                    </div>
                                                </div>
                                                
                                                <!-- Service Details -->
                                                <div class="col-12 mt-4">
                                                    <h5 class="text-muted mb-3">Service Details</h5>
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="countryOfIssue" class="form-label">Country of Issue</label>
                                                        <input type="text" class="form-control" id="countryOfIssue" 
                                                               name="country_of_issue" required>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="serviceType" class="form-label">Service Type</label>
                                                        <select class="form-select" id="serviceType" name="service_type" required>
                                                            <option value="">Select Service Type</option>
                                                            <option value="extension">Extension</option>
                                                            <option value="renewal">Renewal</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="validityPeriod" class="form-label">Validity Period (Months)</label>
                                                        <input type="number" class="form-control" id="validityPeriod" 
                                                               name="validity_period" required min="1">
                                                    </div>
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="expiryDate" class="form-label">Expiry Date</label>
                                                        <input type="date" class="form-control" id="expiryDate" 
                                                               name="expiry_date" required>
                                                    </div>
                                                </div>

                                                <!-- Payment Details -->
                                                <div class="col-12 mt-4">
                                                    <h5 class="text-muted mb-3">Payment Details</h5>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="currency" class="form-label">Currency</label>
                                                        <select class="form-select" id="currency" name="currency" required>
                                                            <option value="KES">Kenyan Shillings (KES)</option>
                                                            <option value="USD">US Dollars (USD)</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="amountReceived" class="form-label">Amount Received</label>
                                                        <div class="input-group">
                                                            <span class="input-group-text currency-symbol">KES</span>
                                                            <input type="number" step="0.01" class="form-control" 
                                                                   id="amountReceived" name="amount_received" required>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="servicePayment" class="form-label">Service Payment</label>
                                                        <div class="input-group">
                                                            <span class="input-group-text currency-symbol">KES</span>
                                                            <input type="number" step="0.01" class="form-control" 
                                                                   id="servicePayment" name="service_payment" required>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="agencyFee" class="form-label">Agency Fee</label>
                                                        <div class="input-group">
                                                            <span class="input-group-text currency-symbol">KES</span>
                                                            <input type="number" step="0.01" class="form-control" 
                                                                   id="agencyFee" readonly>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="paymentStatus" class="form-label">Payment Status</label>
                                                        <select class="form-select" id="paymentStatus" name="payment_status" required>
                                                            <option value="paid">Paid</option>
                                                            <option value="unpaid">Unpaid</option>
                                                            <option value="partial">Partial</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <!-- Additional Information -->
                                                <div class="col-12">
                                                    <div>
                                                        <label for="notes" class="form-label">Notes</label>
                                                        <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                                                    </div>
                                                </div>

                                                <!-- Submit Button -->
                                                <div class="col-12 mt-4">
                                                    <button type="submit" class="btn btn-success btn-label waves-effect waves-light rounded-pill">
                                                        <i class="ri-check-double-line label-icon align-middle rounded-pill fs-16 me-2"></i> 
                                                        Save Extension
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <!--select2 cdn-->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <!-- Sweet Alerts js -->
    <script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>
    <!-- Add this script for form handling -->
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Automatically calculate agency fee
        const amountReceivedInput = document.getElementById('amountReceived');
        const servicePaymentInput = document.getElementById('servicePayment');
        const agencyFeeInput = document.getElementById('agencyFee');

        function calculateAgencyFee() {
            const amountReceived = parseFloat(amountReceivedInput.value) || 0;
            const servicePayment = parseFloat(servicePaymentInput.value) || 0;
            const agencyFee = amountReceived - servicePayment;
            agencyFeeInput.value = agencyFee.toFixed(2);
        }

        amountReceivedInput.addEventListener('input', calculateAgencyFee);
        servicePaymentInput.addEventListener('input', calculateAgencyFee);

        // Automatically calculate expiry date based on validity period
        const extensionDateInput = document.getElementById('extensionDate');
        const validityPeriodInput = document.getElementById('validityPeriod');
        const expiryDateInput = document.getElementById('expiryDate');

        function calculateExpiryDate() {
            const extensionDate = new Date(extensionDateInput.value);
            const validityMonths = parseInt(validityPeriodInput.value) || 0;
            
            if (extensionDate && validityMonths) {
                extensionDate.setMonth(extensionDate.getMonth() + validityMonths);
                const formattedDate = extensionDate.toISOString().split('T')[0];
                expiryDateInput.value = formattedDate;
            }
        }

        extensionDateInput.addEventListener('input', calculateExpiryDate);
        validityPeriodInput.addEventListener('input', calculateExpiryDate);

        // Form submission handling
        const form = document.getElementById('passportExtensionForm');
        form.addEventListener('submit', async function(e) {
            e.preventDefault();

            try {
                const formData = new FormData(this);
                const response = await fetch(this.action, {
                    method: 'POST',
                    body: formData
                });

                const result = await response.json();
                
                if (result.success) {
                    Swal.fire({
                        title: 'Success!',
                        text: 'Passport extension has been saved successfully.',
                        icon: 'success',
                        confirmButtonClass: 'btn btn-primary w-xs mt-2',
                        buttonsStyling: false
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = 'all_extensions.php';
                        }
                    });
                } else {
                    throw new Error(result.message || 'Failed to save extension');
                }
            } catch (error) {
                Swal.fire({
                    title: 'Error!',
                    text: error.message || 'An error occurred while saving the extension.',
                    icon: 'error',
                    confirmButtonClass: 'btn btn-primary w-xs mt-2',
                    buttonsStyling: false
                });
            }
        });
    });
    </script>
    <script>
document.addEventListener('DOMContentLoaded', function() {
    // Get all required elements
    const currencySelect = document.getElementById('currency');
    const currencySymbols = document.querySelectorAll('.currency-symbol');
    const amountReceivedInput = document.getElementById('amountReceived');
    const servicePaymentInput = document.getElementById('servicePayment');
    const agencyFeeInput = document.getElementById('agencyFee');

    // Function to update all currency symbols
    function updateCurrencySymbols() {
        const selectedCurrency = currencySelect.value;
        currencySymbols.forEach(symbol => {
            symbol.textContent = selectedCurrency;
        });
    }

    // Function to calculate agency fee
    function calculateAgencyFee() {
        const amountReceived = parseFloat(amountReceivedInput.value) || 0;
        const servicePayment = parseFloat(servicePaymentInput.value) || 0;
        const agencyFee = amountReceived - servicePayment;
        agencyFeeInput.value = agencyFee.toFixed(2);
    }

    // Function to format amount with proper decimal places
    function formatAmount(input) {
        if (input.value.includes('.')) {
            const parts = input.value.split('.');
            if (parts[1].length > 2) {
                input.value = parseFloat(input.value).toFixed(2);
            }
        }
    }

    // Add event listeners
    currencySelect.addEventListener('change', updateCurrencySymbols);
    amountReceivedInput.addEventListener('input', function() {
        formatAmount(this);
        calculateAgencyFee();
    });
    servicePaymentInput.addEventListener('input', function() {
        formatAmount(this);
        calculateAgencyFee();
    });

    // Initialize currency symbols
    updateCurrencySymbols();
});</script>
</body>
</html>