<?php
class PricingEngine {
    private $basePrice;
    private $taxRate;
    private $discountRate;

    public function __construct($basePrice, $taxRate = 0.16, $discountRate = 0) {
        $this->basePrice = $basePrice;
        $this->taxRate = $taxRate;
        $this->discountRate = $discountRate;
    }

    public function calculateFinalPrice() {
        $priceWithTax = $this->basePrice + ($this->basePrice * $this->taxRate);
        $finalPrice = $priceWithTax - ($priceWithTax * $this->discountRate);
        return number_format($finalPrice, 2);
    }
    
    // New method to get the base price without taxes or discounts
    public function getBasePrice() {
        return number_format($this->basePrice, 2);
    }
}
?>
