<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>

<?php
// Enable error reporting for debugging
ini_set('display_errors', 1); // Enable displaying errors on the page for debugging
ini_set('log_errors', 1); // Enable error logging
ini_set('error_log', 'errors.log'); // Path to the error log file (you can specify any valid path)
error_reporting(E_ALL); // Report all PHP errors (see changelog)

// Include the database connection file
include('layouts/dbconn.php');

// Get the ticket_id from the URL
$ticket_id = isset($_GET['ticket_id']) ? $_GET['ticket_id'] : null;

if (!$ticket_id) {
    die("Ticket ID is required.");
}

// Fetch ticket details from the database along with the customer name
$sql = "SELECT t.*, CONCAT(c.first_name, ' ', c.last_name) AS customer_name
        FROM support_tickets t
        JOIN customers c ON t.customer_id = c.customer_id
        WHERE t.ticket_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $ticket_id);
$stmt->execute();
$result = $stmt->get_result();
$ticket = $result->fetch_assoc();

if (!$ticket) {
    die("Ticket not found.");
}

// Close statement and connection
$stmt->close();
$conn->close();
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Ticket Details')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card mt-n4 mx-n4 mb-n5">
                                <div class="bg-info-subtle">
                                    <div class="card-body pb-4 mb-5">
                                        <div class="row">
                                            <div class="col-md">
                                                <div class="row align-items-center">
                                                    <div class="col-md-auto">
                                                        <div class="avatar-md mb-md-0 mb-4">
                                                            <div class="avatar-title bg-white rounded-circle">
                                                                <img src="assets/images/companies/img-4.png" alt="" class="avatar-sm" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-md">
                                                        <h4 class="fw-semibold" id="ticket-title"><?php echo htmlspecialchars($ticket['ticket_number']); ?> - <?php echo htmlspecialchars($ticket['subject']); ?></h4>
                                                        <div class="hstack gap-3 flex-wrap">
                                                            <div class="text-muted"><i class="ri-building-line align-bottom me-1"></i><span id="ticket-client"><?php echo htmlspecialchars($ticket['customer_name']); ?></span></div>
                                                            <div class="vr"></div>
                                                            <div class="text-muted">Created Date : <span class="fw-medium " id="create-date"><?php echo htmlspecialchars($ticket['created_at']); ?></span></div>
                                                            <div class="vr"></div>
                                                            <div class="text-muted">Due Date : <span class="fw-medium" id="due-date"><?php echo htmlspecialchars($ticket['updated_at']); ?></span></div>
                                                            <div class="vr"></div>
                                                            <div class="badge rounded-pill bg-info fs-12" id="ticket-status"><?php echo htmlspecialchars($ticket['status']); ?></div>
                                                            <div class="badge rounded-pill bg-danger fs-12" id="ticket-priority"><?php echo htmlspecialchars($ticket['priority']); ?></div>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                </div>
                                                <!--end row-->
                                            </div>
                                            <!--end col-->
                                            <div class="col-md-auto mt-md-0 mt-4">
                                                <div class="hstack gap-1 flex-wrap">
                                                    <button type="button" class="btn avatar-xs mt-n1 p-0 favourite-btn active">
                                                        <span class="avatar-title bg-transparent fs-15">
                                                            <i class="ri-star-fill"></i>
                                                        </span>
                                                    </button>
                                                    <button type="button" class="btn py-0 fs-16 text-body" id="settingDropdown" data-bs-toggle="dropdown">
                                                        <i class="ri-share-line"></i>
                                                    </button>
                                                    <ul class="dropdown-menu" aria-labelledby="settingDropdown">
                                                        <li><a class="dropdown-item" href="#"><i class="ri-eye-fill align-bottom me-2 text-muted"></i> View</a></li>
                                                        <li><a class="dropdown-item" href="#"><i class="ri-share-forward-fill align-bottom me-2 text-muted"></i> Share with</a></li>
                                                        <li><a class="dropdown-item" href="#"><i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> Delete</a></li>
                                                    </ul>
                                                    <button type="button" class="btn py-0 fs-16 text-body">
                                                        <a class="dropdown-item" href="all_support_tickets.php"> Back to Tickets</a>
                                                    </button>
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    </div><!-- end card body -->
                                </div>
                            </div><!-- end card -->
                        </div><!-- end col -->
                    </div><!-- end row -->

                    <div class="row">
                        <div class="col-xxl-9">
                            <div class="card">
                                <div class="card-body p-4">
                                    <h6 class="fw-semibold text-uppercase mb-3">Ticket Description</h6>
                                    <p class="text-muted"><?php echo htmlspecialchars($ticket['description']); ?></p>
                                    <h6 class="fw-semibold text-uppercase mb-3">Ticket Subject</h6>
                                    <?php echo htmlspecialchars($ticket['subject']); ?>
                                </div>
                                <!--end card-body-->
                                
                            </div>
                            <!--end card-->
                        </div>
                        <!--end col-->
                        <div class="col-xxl-3">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Ticket Details</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive table-card">
                                        <table class="table table-borderless align-middle mb-0">
                                            <tbody>
                                                <tr>
                                                    <td class="fw-semibold">Ticket</td>
                                                    <td>#<span id="t-no"><?php echo htmlspecialchars($ticket['ticket_number']); ?></span> </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Client</td>
                                                    <td id="t-client"><?php echo htmlspecialchars($ticket['customer_name']); ?></td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Status:</td>
                                                    <td>
                                                        <select class="form-select" id="t-status" data-choices data-choices-search-false aria-label="Default select example">
                                                            <option value>Status</option>
                                                            <option value="New" <?php echo ($ticket['status'] == 'New') ? 'selected' : ''; ?>>New</option>
                                                            <option value="Open" <?php echo ($ticket['status'] == 'Open') ? 'selected' : ''; ?>>Open</option>
                                                            <option value="Inprogress" <?php echo ($ticket['status'] == 'Inprogress') ? 'selected' : ''; ?>>Inprogress</option>
                                                            <option value="Closed" <?php echo ($ticket['status'] == 'Closed') ? 'selected' : ''; ?>>Closed</option>
                                                        </select>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Priority</td>
                                                    <td>
                                                        <span class="badge bg-danger" id="t-priority"><?php echo htmlspecialchars($ticket['priority']); ?></span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Created Date</td>
                                                    <td id="c-date"><?php echo htmlspecialchars($ticket['created_at']); ?></td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Due Date</td>
                                                    <td id="d-date"><?php echo htmlspecialchars($ticket['updated_at']); ?></td>
                                                </tr>
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <!--end card-body-->
                            </div>
                            <!--end card-->
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->

                </div><!-- container-fluid -->
            </div><!-- End Page-content -->

            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/customizer.php'; ?>

    <?php include 'layouts/vendor-scripts.php'; ?>

    <!-- ticketdetail init js -->
    <script src="assets/js/pages/ticketdetail.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.js"></script>

</body>

</html>
