<?php
// Function to check user role
function hasRole($allowedRoles) {
    $userRole = $_SESSION['role_id'] ?? '';
    return in_array($userRole, $allowedRoles);
}
?>

<!-- ========== App Menu ========== -->
<div class="app-menu navbar-menu">
    <!-- LOGO -->
    <div class="navbar-brand-box">
        <!-- Dark Logo-->
        <a href="index.php" class="logo logo-dark">
            <span class="logo-sm">
                <img src="assets/images/awt_logo.png" alt="" height="40">
            </span>
            <span class="logo-lg">
                <img src="assets/images/awt_logo.png" alt="" height="40">
            </span>
        </a>
        <!-- Light Logo-->
        <a href="index.php" class="logo logo-light">
            <span class="logo-sm">
                <img src="assets/images/awt_logo.png" alt="" height="40">
            </span>
            <span class="logo-lg">
                <img src="assets/images/awt_logo.png" alt="" height="40">
            </span>
        </a>
        <button type="button" class="btn btn-sm p-0 fs-20 header-item float-end btn-vertical-sm-hover" id="vertical-hover">
            <i class="ri-record-circle-line"></i>
        </button>
    </div>

    <div id="scrollbar">
        <div class="container-fluid">
            <div id="two-column-menu"></div>
            <ul class="navbar-nav" id="navbar-nav">
               <!-- Dashboard - Visible to all but with different destinations -->
                <li class="menu-title"><span data-key="t-menu">Menu</span></li>
                <li class="nav-item">
                    <?php
                    if (hasRole([1, 2, 3])) {
                        $dashboardLink = "index.php";
                    } else {
                        $dashboardLink = "dashboard.php";
                    }
                    ?>
                    <a class="nav-link menu-link" href="<?php echo $dashboardLink; ?>">
                        <i class="ri-dashboard-2-line"></i> <span data-key="t-dashboards">Dashboard</span>
                    </a>
                </li>

                <?php if (hasRole([1, 2, 3, 4])): // Admin, GM, Operations ?>
                <!-- Cargo Management -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-cargo">Cargo Management</span></li>
                <li class="nav-item">
                    <a class="nav-link menu-link" href="#sidebarCargo" data-bs-toggle="collapse" role="button">
                        <i class="ri-box-3-line"></i> <span data-key="t-manage-cargo">Manage Cargo</span>
                    </a>
                    <div class="collapse menu-dropdown" id="sidebarCargo">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a href="all_cargo.php" class="nav-link">View All Cargo</a>
                            </li>
                            <li class="nav-item">
                                <a href="add_cargo.php" class="nav-link">Add New Cargo</a>
                            </li>
                            <li class="nav-item">
                                <a href="add_cargo_payment.php" class="nav-link">Add Cargo Payment</a>
                            </li>
                            <li class="nav-item">
                                <a href="all_cargo_status.php" class="nav-link">View Cargo Status</a>
                            </li>
                        </ul>
                    </div>
                </li>
                <?php endif; ?>

                <?php if (hasRole([1, 2, 3, 4, 5])): // Admin, GM, Operations, Employee ?>
                <!-- Bookings Management -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-bookings">Bookings Management</span></li>
                <li class="nav-item">
                    <a href="add_tickets.php" class="nav-link">
                        <i class="ri-ticket-2-line"></i> <span>Create Ticket Booking</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="all_new_tickets.php" class="nav-link">
                        <i class="ri-file-list-3-line"></i> <span>View All Bookings</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="all_cancellations.php" class="nav-link">
                        <i class="ri-close-circle-line"></i> <span>View All Cancellations</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="add_visa.php" class="nav-link">
                        <i class="ri-passport-line"></i> <span>Create VISA Booking</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="all_visas.php" class="nav-link">
                        <i class="ri-file-list-line"></i> <span>View All VISA Bookings</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="add_extension.php" class="nav-link">
                        <i class="ri-calendar-check-line"></i> <span>Passport Extension</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="all_extensions.php" class="nav-link">
                        <i class="ri-file-paper-line"></i> <span>All Passport Extensions</span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if (hasRole([1, 2, 3, 4])): // Admin, GM, Operations ?>
                <!-- Customer Management -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-customer">Customers Management</span></li>
                <li class="nav-item">
                    <a href="all_customers.php" class="nav-link">
                        <i class="ri-contacts-fill"></i> <span>View All Customers</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="add_customer.php" class="nav-link">
                        <i class="ri-user-add-line"></i> <span>Add New Customer</span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if (hasRole([1, 2])): // Admin, GM ?>
                <!-- User Management -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-user">User Management</span></li>
                <li class="nav-item">
                    <a href="all_users.php" class="nav-link">
                        <i class="ri-group-line"></i> <span>View All Users</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="add_user.php" class="nav-link">
                        <i class="ri-user-add-line"></i> <span>Add New User</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="all_roles.php" class="nav-link">
                        <i class="ri-user-add-line"></i> <span>All User Roles</span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if (hasRole([1, 2, 4])): // Admin, GM, Finance ?>
                <!-- Payments & Invoicing -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-payment">Payments & Invoicing</span></li>
                <li class="nav-item">
                    <a href="all_payments.php" class="nav-link">
                        <i class="ri-currency-line"></i> <span>View All Payments</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="add_payment.php" class="nav-link">
                        <i class="ri-money-dollar-circle-line"></i> <span>Add New Payment</span>
                    </a>
                </li>
                
                <!-- Expense Management -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span>Expense Management</span></li>
                <li class="nav-item">
                    <a href="all_expenses.php" class="nav-link">
                        <i class="ri-funds-line"></i> <span>View All Expenses</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="add_expense.php" class="nav-link">
                        <i class="ri-add-circle-line"></i> <span>Add New Expense</span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if (hasRole([1, 2, 3, 5])): // Admin, GM, Operations, Employee ?>
                <!-- Ticket Management -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span>Ticket Management</span></li>
                <li class="nav-item">
                    <a href="all_new_tickets.php" class="nav-link">
                        <i class="ri-ticket-2-line"></i> <span>View All Tickets</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="add_ticket.php" class="nav-link">
                        <i class="ri-printer-cloud-line"></i> <span>Manual Ticket Issuance</span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if (hasRole([1, 2, 4])): // Admin, GM, Finance ?>
                <!-- Reports & Analytics -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span>Reports & Analytics</span></li>
                <li class="nav-item">
                    <a href="financial_report.php" class="nav-link">
                        <i class="ri-pie-chart-2-line"></i> <span>Financial Reports</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="operational_report.php" class="nav-link">
                        <i class="ri-bar-chart-box-line"></i> <span>Operational Reports</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="cargo_report.php" class="nav-link">
                        <i class="ri-file-chart-line"></i> <span>Cargo Manifest Reports</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="visa_report.php" class="nav-link">
                        <i class="ri-file-chart-line"></i> <span>Visa Reports</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="passport_reports.php" class="nav-link">
                        <i class="ri-file-chart-line"></i> <span>Passport Reports</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="tickets_report.php" class="nav-link">
                        <i class="ri-file-chart-line"></i> <span>Ticket Reports</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="agency_earnings.php" class="nav-link">
                        <i class="ri-line-chart-line"></i> <span>Agency Earnings Report</span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if (hasRole([1, 2])): // Admin, GM only ?>
                <!-- System Settings -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span>System Settings</span></li>
                <li class="nav-item">
                    <a href="settings.php" class="nav-link">
                        <i class="ri-settings-5-line"></i> <span>General Settings</span>
                    </a>
                </li>
                 <li class="nav-item">
                        <a href="backup.php" class="nav-link">
                            <i class="ri-database-2-line"></i> <span>Backup & Restore</span>
                        </a>
                    </li>
                <li class="nav-item">
                    <a href="audit_logs.php" class="nav-link">
                        <i class="ri-history-line"></i> <span>Audit Logs</span>
                    </a>
                </li>
                <?php endif; ?>
                
                <!-- Add a divider before logout -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span>Account</span></li>
                
                <!-- Logout link - visible to all users -->
                <li class="nav-item">
                    <a href="logout.php" class="nav-link">
                        <i class="ri-logout-box-line"></i> <span>Logout</span>
                    </a>
                </li>
            </ul>
        </div>
    </div>
    <div class="sidebar-background"></div>
</div>
<!-- Left Sidebar End -->
<!-- Vertical Overlay-->
<div class="vertical-overlay"></div>