<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'User Roles')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <!-- DataTables CSS -->
    <link href="assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Roles', 'title' => 'User Roles')); ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header d-flex align-items-center">
                                    <h5 class="card-title mb-0 flex-grow-1">All User Roles</h5>
                                    <a href="add_role.php" class="btn btn-primary">
                                        <i class="ri-add-line align-middle me-1"></i> Add New Role
                                    </a>
                                </div>
                                <div class="card-body">
                                    <table id="roles-table" class="table table-bordered dt-responsive nowrap table-striped">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Role Name</th>
                                                <th>Total Users</th>
                                                <th>Created Date</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $sql = "SELECT r.*, COUNT(ur.user_id) as user_count 
                                                   FROM user_role r 
                                                   LEFT JOIN user_roles ur ON r.role_id = ur.role_id 
                                                   GROUP BY r.role_id 
                                                   ORDER BY r.role_name";
                                            $result = $conn->query($sql);

                                            if ($result->num_rows > 0) {
                                                while($row = $result->fetch_assoc()) {
                                                    $statusClass = $row['user_count'] > 0 ? 'badge bg-success' : 'badge bg-warning';
                                                    $statusText = $row['user_count'] > 0 ? 'Active' : 'Unused';

                                                    echo "<tr>";
                                                    echo "<td>{$row['role_id']}</td>";
                                                    echo "<td>{$row['role_name']}</td>";
                                                    echo "<td>{$row['user_count']}</td>";
                                                    echo "<td>" . date('d M Y', strtotime($row['created_at'] ?? 'now')) . "</td>";
                                                    echo "<td><span class='{$statusClass}'>{$statusText}</span></td>";
                                                    echo "<td>
                                                            <div class='d-flex gap-2'>
                                                                <a href='view_role.php?id={$row['role_id']}' 
                                                                   class='btn btn-sm btn-soft-primary'>
                                                                    <i class='ri-eye-fill'></i>
                                                                </a>
                                                                <a href='edit_role.php?id={$row['role_id']}' 
                                                                   class='btn btn-sm btn-soft-info'>
                                                                    <i class='ri-pencil-fill'></i>
                                                                </a>";
                                                    if ($row['user_count'] == 0) {
                                                        echo "<button type='button' 
                                                                    class='btn btn-sm btn-soft-danger delete-role'
                                                                    data-id='{$row['role_id']}'>
                                                                <i class='ri-delete-bin-line'></i>
                                                            </button>";
                                                    }
                                                    echo "</div>
                                                          </td>";
                                                    echo "</tr>";
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    
    <!-- DataTables JS -->
    <script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
    $(document).ready(function() {
        // Initialize DataTable
        $('#roles-table').DataTable({
            order: [[1, 'asc']], // Sort by role name ascending
            pageLength: 25,
            language: {
                search: "_INPUT_",
                searchPlaceholder: "Search roles..."
            }
        });

        // Handle delete button clicks
        $('.delete-role').on('click', function() {
            const roleId = $(this).data('id');
            
            Swal.fire({
                title: 'Are you sure?',
                text: "This action cannot be undone",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'btn btn-primary w-xs me-2 mt-2',
                cancelButtonClass: 'btn btn-danger w-xs mt-2',
                confirmButtonText: 'Yes, delete it!',
                buttonsStyling: false,
                showCloseButton: true
            }).then((result) => {
                if (result.isConfirmed) {
                    // Send delete request
                    $.ajax({
                        url: 'delete_role.php',
                        type: 'POST',
                        data: { role_id: roleId },
                        success: function(response) {
                            const data = JSON.parse(response);
                            if (data.success) {
                                Swal.fire({
                                    title: 'Deleted!',
                                    text: data.message,
                                    icon: 'success',
                                    confirmButtonClass: 'btn btn-primary w-xs mt-2',
                                    buttonsStyling: false
                                }).then(() => {
                                    location.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data.message,
                                    icon: 'error',
                                    confirmButtonClass: 'btn btn-primary w-xs mt-2',
                                    buttonsStyling: false
                                });
                            }
                        },
                        error: function() {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Failed to delete role',
                                icon: 'error',
                                confirmButtonClass: 'btn btn-primary w-xs mt-2',
                                buttonsStyling: false
                            });
                        }
                    });
                }
            });
        });
    });
    </script>
</body>
</html>