<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<?php
$booking_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$query = "SELECT b.*, 
          CONCAT(c.first_name, ' ', c.last_name) as customer_name,
          c.email as customer_email,
          c.phone_number as customer_phone,
          f.flight_number,
          f.departure_date,
          f.arrival_date,
          f.origin,
          f.destination,
          u.full_name as cancelled_by
          FROM bookings b
          LEFT JOIN customers c ON b.customer_id = c.customer_id
          LEFT JOIN flights f ON b.flight_id = f.flight_id
          LEFT JOIN users u ON b.user_id = u.user_id
          WHERE b.booking_id = ?";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $booking_id);
$stmt->execute();
$booking = $stmt->get_result()->fetch_assoc();
?>

<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable">

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Cancellation Details')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Bookings Management', 'title' => 'Cancellation Details')); ?>

                    <div class="row">
                        <div class="col-xl-8">
                            <div class="card">
                                <div class="card-header">
                                    <div class="d-flex align-items-center">
                                        <h5 class="card-title flex-grow-1 mb-0">Cancellation Details</h5>
                                        <?php if (!$booking['refund_date']): ?>
                                        <a href="process_refund.php?id=<?php echo $booking_id; ?>" 
                                           class="btn btn-success btn-sm">
                                            <i class="ri-money-dollar-circle-fill align-middle me-1"></i> Process Refund
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-borderless mb-0">
                                            <tbody>
                                                <tr>
                                                    <th scope="row">Booking Code :</th>
                                                    <td><?php echo $booking['booking_code']; ?></td>
                                                    <th scope="row">Status :</th>
                                                    <td><span class="badge bg-danger">Cancelled</span></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Booking Date :</th>
                                                    <td><?php echo date('d M Y', strtotime($booking['booking_date'])); ?></td>
                                                    <th scope="row">Cancellation Date :</th>
                                                    <td><?php echo date('d M Y', strtotime($booking['cancellation_date'])); ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Total Amount :</th>
                                                    <td><?php echo number_format($booking['total_amount'], 2); ?></td>
                                                    <th scope="row">Refund Amount :</th>
                                                    <td><?php echo $booking['refund_amount'] ? number_format($booking['refund_amount'], 2) : 'Pending'; ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Flight Number :</th>
                                                    <td><?php echo $booking['flight_number']; ?></td>
                                                    <th scope="row">Route :</th>
                                                    <td><?php echo $booking['origin'] . ' → ' . $booking['destination']; ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Cancelled By :</th>
                                                    <td><?php echo $booking['cancelled_by']; ?></td>
                                                    <th scope="row">Refund Date :</th>
                                                    <td><?php echo $booking['refund_date'] ? date('d M Y', strtotime($booking['refund_date'])) : 'Pending'; ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Cancellation Reason</h5>
                                </div>
                                <div class="card-body">
                                    <p class="text-muted"><?php echo nl2br(htmlspecialchars($booking['cancellation_reason'])); ?></p>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Customer Details</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-borderless mb-0">
                                            <tbody>
                                                <tr>
                                                    <th scope="row">Name :</th>
                                                    <td><?php echo htmlspecialchars($booking['customer_name']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Email :</th>
                                                    <td><?php echo htmlspecialchars($booking['customer_email']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Phone :</th>
                                                    <td><?php echo htmlspecialchars($booking['customer_phone']); ?></td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Total Passengers :</th>
                                                    <td><?php echo $booking['total_passengers']; ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
</body>
</html>