<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>

<?php
include 'layouts/dbconn.php';

// Check if user ID is provided - FIXED to use 'user_id' parameter
if (!isset($_GET['user_id']) || empty($_GET['user_id'])) {
    header('Location: all_users.php');
    exit;
}

$user_id = intval($_GET['user_id']);

// Fetch user details
$query = "SELECT u.*, ur.role_name, 
                 u.full_name as created_by_name,
                 s.staff_id, s.employee_id, s.department, s.position, s.date_hired,
                 s.phone as staff_phone, s.address, s.city, s.country, s.status as staff_status
          FROM users u
          LEFT JOIN user_role ur ON u.role_id = ur.role_id
          LEFT JOIN staff s ON u.user_id = s.staff_id
          WHERE u.user_id = ?";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user) {
    header('Location: all_users.php');
    exit;
}

// Get user's recent activity
$activity_query = "SELECT action, log_details, log_time, ip_address
                  FROM audit_logs 
                  WHERE user_id = ? 
                  ORDER BY log_time DESC 
                  LIMIT 10";

$stmt = $conn->prepare($activity_query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$activities = $stmt->get_result();

// Get login history - FIXED QUERY without ip_address
$login_query = "SELECT session_id, created_at, last_activity, expires_at, is_active
               FROM sessions 
               WHERE user_id = ? 
               ORDER BY created_at DESC 
               LIMIT 10";

$stmt = $conn->prepare($login_query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$logins = $stmt->get_result();

// Get failed login attempts
$failed_query = "SELECT attempt_time, ip_address, user_agent
                FROM failed_logins 
                WHERE user_id = ? 
                ORDER BY attempt_time DESC 
                LIMIT 5";

$stmt = $conn->prepare($failed_query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$failed_logins = $stmt->get_result();
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'View User')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <style>
        .info-card {
            border-left: 3px solid #4c9ce2;
        }
        .activity-card {
            border-left: 3px solid #28a745;
        }
        .login-card {
            border-left: 3px solid #ffc107;
        }
        .failed-card {
            border-left: 3px solid #dc3545;
        }
        .status-badge-active {
            background-color: #28a745;
            color: white;
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 12px;
        }
        .status-badge-inactive {
            background-color: #dc3545;
            color: white;
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 12px;
        }
    </style>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'User Management', 'title' => 'User Details')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="d-flex align-items-center">
                                        <h5 class="card-title mb-0 flex-grow-1">User Information</h5>
                                        <div class="flex-shrink-0">
                                            <a href="edit_user.php?user_id=<?php echo $user_id; ?>" class="btn btn-primary">
                                                <i class="ri-pencil-fill align-bottom me-1"></i> Edit User
                                            </a>
                                            <a href="all_users.php" class="btn btn-secondary">
                                                <i class="ri-arrow-left-line align-bottom me-1"></i> Back
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <!-- User Details -->
                                        <div class="col-md-6">
                                            <div class="card info-card">
                                                <div class="card-body">
                                                    <h6 class="mb-3 text-muted">Account Information</h6>
                                                    <table class="table table-borderless">
                                                        <tr>
                                                            <td width="30%"><strong>User ID:</strong></td>
                                                            <td><?php echo $user['user_id']; ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Username:</strong></td>
                                                            <td><?php echo htmlspecialchars($user['username']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Full Name:</strong></td>
                                                            <td><?php echo htmlspecialchars($user['full_name']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Email:</strong></td>
                                                            <td><?php echo htmlspecialchars($user['email']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Role:</strong></td>
                                                            <td><?php echo htmlspecialchars($user['role_name']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Status:</strong></td>
                                                            <td>
                                                                <?php if ($user['verified'] == 1): ?>
                                                                    <span class="status-badge-active">Active</span>
                                                                <?php else: ?>
                                                                    <span class="status-badge-inactive">Inactive</span>
                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Created At:</strong></td>
                                                            <td><?php echo date('d M Y H:i', strtotime($user['created_at'])); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Last Active:</strong></td>
                                                            <td><?php echo $user['last_active'] ? date('d M Y H:i', strtotime($user['last_active'])) : 'N/A'; ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Last Password Change:</strong></td>
                                                            <td><?php echo date('d M Y H:i', strtotime($user['last_password_change'])); ?></td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Staff Information (if linked) -->
                                        <div class="col-md-6">
                                            <div class="card info-card">
                                                <div class="card-body">
                                                    <h6 class="mb-3 text-muted">Staff Information</h6>
                                                    <?php if ($user['staff_id']): ?>
                                                    <table class="table table-borderless">
                                                        <tr>
                                                            <td width="30%"><strong>Employee ID:</strong></td>
                                                            <td><?php echo htmlspecialchars($user['employee_id']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Department:</strong></td>
                                                            <td><?php echo htmlspecialchars($user['department']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Position:</strong></td>
                                                            <td><?php echo htmlspecialchars($user['position']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Date Hired:</strong></td>
                                                            <td><?php echo $user['date_hired'] ? date('d M Y', strtotime($user['date_hired'])) : 'N/A'; ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Phone:</strong></td>
                                                            <td><?php echo htmlspecialchars($user['staff_phone']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Address:</strong></td>
                                                            <td><?php echo htmlspecialchars($user['address']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>City:</strong></td>
                                                            <td><?php echo htmlspecialchars($user['city']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Country:</strong></td>
                                                            <td><?php echo htmlspecialchars($user['country']); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><strong>Staff Status:</strong></td>
                                                            <td>
                                                                <?php
                                                                $status_class = '';
                                                                switch($user['staff_status']) {
                                                                    case 'active':
                                                                        $status_class = 'status-badge-active';
                                                                        break;
                                                                    case 'inactive':
                                                                    case 'suspended':
                                                                        $status_class = 'status-badge-inactive';
                                                                        break;
                                                                }
                                                                ?>
                                                                <span class="<?php echo $status_class; ?>"><?php echo ucfirst($user['staff_status']); ?></span>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    <?php else: ?>
                                                    <p class="text-muted">This user is not linked to a staff record.</p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Recent Activity -->
                                    <div class="row mt-4">
                                        <div class="col-md-6">
                                            <div class="card activity-card">
                                                <div class="card-body">
                                                    <h6 class="mb-3 text-muted">Recent Activity</h6>
                                                    <div class="table-responsive">
                                                        <table class="table table-sm">
                                                            <thead>
                                                                <tr>
                                                                    <th>Action</th>
                                                                    <th>Details</th>
                                                                    <th>Time</th>
                                                                    <th>IP</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php
                                                                if ($activities->num_rows > 0) {
                                                                    while ($activity = $activities->fetch_assoc()) {
                                                                        ?>
                                                                        <tr>
                                                                            <td><?php echo htmlspecialchars($activity['action']); ?></td>
                                                                            <td><?php echo htmlspecialchars(substr($activity['log_details'], 0, 50)) . '...'; ?></td>
                                                                            <td><?php echo date('d M Y H:i', strtotime($activity['log_time'])); ?></td>
                                                                            <td><?php echo htmlspecialchars($activity['ip_address']); ?></td>
                                                                        </tr>
                                                                        <?php
                                                                    }
                                                                } else {
                                                                    echo "<tr><td colspan='4' class='text-center'>No recent activity</td></tr>";
                                                                }
                                                                ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Login History -->
                                        <div class="col-md-6">
                                            <div class="card login-card">
                                                <div class="card-body">
                                                    <h6 class="mb-3 text-muted">Login History</h6>
                                                    <div class="table-responsive">
                                                        <table class="table table-sm">
                                                            <thead>
                                                                <tr>
                                                                    <th>Login Time</th>
                                                                    <th>Last Activity</th>
                                                                    <th>Status</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php
                                                                if ($logins->num_rows > 0) {
                                                                    while ($login = $logins->fetch_assoc()) {
                                                                        ?>
                                                                        <tr>
                                                                            <td><?php echo date('d M Y H:i', strtotime($login['created_at'])); ?></td>
                                                                            <td><?php echo date('d M Y H:i', strtotime($login['last_activity'])); ?></td>
                                                                            <td>
                                                                                <?php if ($login['is_active']): ?>
                                                                                    <span class="status-badge-active">Active</span>
                                                                                <?php else: ?>
                                                                                    <span class="status-badge-inactive">Expired</span>
                                                                                <?php endif; ?>
                                                                            </td>
                                                                        </tr>
                                                                        <?php
                                                                    }
                                                                } else {
                                                                    echo "<tr><td colspan='3' class='text-center'>No login history</td></tr>";
                                                                }
                                                                ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Failed Login Attempts -->
                                    <?php if ($failed_logins->num_rows > 0): ?>
                                    <div class="row mt-4">
                                        <div class="col-md-12">
                                            <div class="card failed-card">
                                                <div class="card-body">
                                                    <h6 class="mb-3 text-muted">Failed Login Attempts</h6>
                                                    <div class="table-responsive">
                                                        <table class="table table-sm">
                                                            <thead>
                                                                <tr>
                                                                    <th>Attempt Time</th>
                                                                    <th>IP Address</th>
                                                                    <th>User Agent</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php
                                                                while ($failed = $failed_logins->fetch_assoc()) {
                                                                    ?>
                                                                    <tr>
                                                                        <td><?php echo date('d M Y H:i', strtotime($failed['attempt_time'])); ?></td>
                                                                        <td><?php echo htmlspecialchars($failed['ip_address']); ?></td>
                                                                        <td><?php echo htmlspecialchars(substr($failed['user_agent'], 0, 50)) . '...'; ?></td>
                                                                    </tr>
                                                                    <?php
                                                                }
                                                                ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
</body>
</html>