<?php
include 'layouts/dbconn.php'; // Include your database connection

// Ensure form was submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get the customer data from the form
    $firstName = $_POST['first_name'];
    $lastName = $_POST['last_name'];
    $email = $_POST['email'];
    $phoneNumber = $_POST['phone_number'];
    $passportNumber = $_POST['passport'];
    $address = $_POST['address'];
    $city = $_POST['city'];
    $country = $_POST['country'];

    // Prepare and execute the insert
    $stmt = $conn->prepare("INSERT INTO customers (user_id, first_name, last_name, email, phone_number, passport, address, city, country) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $userId = 1; // Set your user ID appropriately
    $stmt->bind_param("issssssss", $userId, $firstName, $lastName, $email, $phoneNumber, $passportNumber, $address, $city, $country);
    
    if ($stmt->execute()) {
        // Return success response with new customer ID
        echo json_encode([
            'success' => true,
            'customer_id' => $stmt->insert_id,
            'first_name' => $firstName,
            'last_name' => $lastName,
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => $stmt->error,
        ]);
    }

    $stmt->close();
}
$conn->close();
?>
