<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<?php
// Fetch booking details if editing
$booking_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$booking = null;

if ($booking_id) {
    $query = "SELECT b.*, 
              CONCAT(c.first_name, ' ', c.last_name) as customer_name,
              f.flight_number
              FROM bookings b
              LEFT JOIN customers c ON b.customer_id = c.customer_id
              LEFT JOIN flights f ON b.flight_id = f.flight_id
              WHERE b.booking_id = ?";
              
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $booking_id);
    $stmt->execute();
    $booking = $stmt->get_result()->fetch_assoc();
}
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Process Cancellation')); ?>
    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Bookings Management', 'title' => 'Process Cancellation')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Process Booking Cancellation</h4>
                                </div>
                                <div class="card-body">
                                    <form action="save_cancellation.php" method="post" id="cancellationForm">
                                        <input type="hidden" name="booking_id" value="<?php echo $booking_id; ?>">
                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Booking Code</label>
                                                    <input type="text" class="form-control" value="<?php echo $booking['booking_code']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Customer Name</label>
                                                    <input type="text" class="form-control" value="<?php echo $booking['customer_name']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Flight Number</label>
                                                    <input type="text" class="form-control" value="<?php echo $booking['flight_number']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Total Amount</label>
                                                    <input type="text" class="form-control" value="<?php echo number_format($booking['total_amount'], 2); ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Cancellation Reason</label>
                                                    <textarea class="form-control" name="cancellation_reason" rows="3" required><?php echo $booking['cancellation_reason']; ?></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Refund Amount</label>
                                                    <input type="number" step="0.01" class="form-control" name="refund_amount" value="<?php echo $booking['refund_amount']; ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Refund Date</label>
                                                    <input type="date" class="form-control" name="refund_date" value="<?php echo $booking['refund_date'] ? date('Y-m-d', strtotime($booking['refund_date'])) : date('Y-m-d'); ?>" required>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row mt-4">
                                            <div class="col-12">
                                                <button type="submit" class="btn btn-primary">Process Cancellation</button>
                                                <a href="cancellations.php" class="btn btn-secondary">Cancel</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    
    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>

    <script>
    $(document).ready(function() {
        $("#cancellationForm").on('submit', function(e) {
            if (!confirm('Are you sure you want to process this cancellation?')) {
                e.preventDefault();
            }
        });
    });
    </script>
</body>
</html>