-- Database Backup
-- Generated: 2025-05-05 10:07:49

SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `admin_logs`;
CREATE TABLE `admin_logs` (
  `log_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`log_id`),
  KEY `user_id` (`user_id`),
  KEY `action` (`action`),
  KEY `created_at` (`created_at`),
  CONSTRAINT `admin_logs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `aircraft`;
CREATE TABLE `aircraft` (
  `aircraft_id` int NOT NULL AUTO_INCREMENT,
  `model` varchar(100) NOT NULL,
  `manufacturer` varchar(100) NOT NULL,
  `seating_capacity` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`aircraft_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `airports`;
CREATE TABLE `airports` (
  `airport_id` int NOT NULL AUTO_INCREMENT,
  `airport_code` varchar(10) NOT NULL,
  `airport_name` varchar(255) NOT NULL,
  `city` varchar(100) NOT NULL,
  `country` varchar(100) NOT NULL,
  `latitude` decimal(9,6) DEFAULT NULL,
  `longitude` decimal(9,6) DEFAULT NULL,
  `elevation` int DEFAULT NULL,
  PRIMARY KEY (`airport_id`),
  UNIQUE KEY `airport_code` (`airport_code`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `audit_logs`;
CREATE TABLE `audit_logs` (
  `log_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `action` varchar(255) NOT NULL,
  `log_details` text,
  `log_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip_address` varchar(45) NOT NULL,
  `user_agent` text NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `backup_settings`;
CREATE TABLE `backup_settings` (
  `setting_id` int NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `setting_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`setting_id`),
  UNIQUE KEY `setting_key` (`setting_key`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `baggage`;
CREATE TABLE `baggage` (
  `baggage_id` int NOT NULL AUTO_INCREMENT,
  `booking_id` int NOT NULL,
  `weight` decimal(5,2) NOT NULL,
  `tag_number` varchar(20) NOT NULL,
  `status` enum('Checked','Loaded','Unloaded','Claimed','Lost') DEFAULT 'Checked',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`baggage_id`),
  UNIQUE KEY `tag_number` (`tag_number`),
  KEY `booking_id` (`booking_id`),
  CONSTRAINT `baggage_ibfk_1` FOREIGN KEY (`booking_id`) REFERENCES `bookings` (`booking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `booking_code_sequence`;
CREATE TABLE `booking_code_sequence` (
  `id` int NOT NULL AUTO_INCREMENT,
  `next_val` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `booking_fees`;
CREATE TABLE `booking_fees` (
  `fee_id` int NOT NULL AUTO_INCREMENT,
  `booking_id` int NOT NULL,
  `agency_fee_percentage` decimal(5,2) DEFAULT NULL,
  `agency_fee_amount` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`fee_id`),
  KEY `booking_id` (`booking_id`),
  CONSTRAINT `fk_booking_fees_booking` FOREIGN KEY (`booking_id`) REFERENCES `bookings` (`booking_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `booking_insurance`;
CREATE TABLE `booking_insurance` (
  `booking_insurance_id` int NOT NULL AUTO_INCREMENT,
  `booking_id` int NOT NULL,
  `plan_id` int NOT NULL,
  `purchase_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('Active','Cancelled','Claimed') DEFAULT 'Active',
  PRIMARY KEY (`booking_insurance_id`),
  KEY `booking_id` (`booking_id`),
  KEY `plan_id` (`plan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `bookings`;
CREATE TABLE `bookings` (
  `booking_id` int NOT NULL AUTO_INCREMENT,
  `booking_code` varchar(10) NOT NULL,
  `customer_id` int NOT NULL,
  `user_id` int NOT NULL,
  `flight_id` int NOT NULL,
  `promotion_id` int DEFAULT NULL,
  `booking_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('Booked','Cancelled') DEFAULT 'Booked',
  `total_amount` decimal(10,2) NOT NULL,
  `cancellation_reason` text,
  `cancellation_date` timestamp NULL DEFAULT NULL,
  `refund_amount` decimal(10,2) DEFAULT NULL,
  `refund_date` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `total_passengers` int DEFAULT '1',
  `payment_status` enum('Pending','Partially Paid','Fully Paid') DEFAULT 'Pending',
  `remaining_balance` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`booking_id`),
  UNIQUE KEY `booking_code` (`booking_code`),
  UNIQUE KEY `idx_customer_flight` (`customer_id`,`flight_id`),
  KEY `customer_id` (`customer_id`),
  KEY `user_id` (`user_id`),
  KEY `flight_id` (`flight_id`),
  KEY `promotion_id` (`promotion_id`),
  KEY `idx_booking_date` (`booking_date`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `cargo_bookings`;
CREATE TABLE `cargo_bookings` (
  `booking_id` int NOT NULL AUTO_INCREMENT,
  `booking_number` varchar(20) NOT NULL,
  `sender_customer_id` int NOT NULL,
  `sender_address_id` int NOT NULL,
  `receiver_customer_id` int DEFAULT NULL,
  `receiver_address_id` int NOT NULL,
  `receiver_name` varchar(100) DEFAULT NULL,
  `receiver_phone` varchar(20) DEFAULT NULL,
  `receiver_email` varchar(100) DEFAULT NULL,
  `cargo_type` varchar(50) NOT NULL,
  `weight` decimal(10,2) NOT NULL,
  `rate` int DEFAULT NULL,
  `dimensions` varchar(50) DEFAULT NULL,
  `special_instructions` text,
  `booking_status` enum('pending','confirmed','picked_up','in_office','in_transit','arrived_destination','out_for_delivery','delivered','failed_delivery','on_hold','cancelled','returned') DEFAULT 'pending',
  `payment_status` enum('unpaid','partially_paid','paid','payment_failed','refunded','cancelled') DEFAULT 'unpaid',
  `booking_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `pickup_date` datetime DEFAULT NULL,
  `estimated_delivery_date` date DEFAULT NULL,
  `actual_delivery_date` datetime DEFAULT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `currency` enum('KES','USD') NOT NULL DEFAULT 'KES',
  `paid_amount` decimal(10,2) DEFAULT '0.00',
  `delivery_attempts` int DEFAULT '0',
  `last_attempt_date` datetime DEFAULT NULL,
  `last_status_update` timestamp NULL DEFAULT NULL,
  `last_status_update_by` int DEFAULT NULL,
  `status_notes` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `payment_date` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`booking_id`),
  UNIQUE KEY `booking_number` (`booking_number`),
  KEY `sender_customer_id` (`sender_customer_id`),
  KEY `receiver_customer_id` (`receiver_customer_id`),
  KEY `sender_address_id` (`sender_address_id`),
  KEY `receiver_address_id` (`receiver_address_id`),
  KEY `last_status_update_by` (`last_status_update_by`),
  KEY `idx_booking_number` (`booking_number`),
  KEY `idx_booking_status` (`booking_status`),
  KEY `idx_payment_status` (`payment_status`),
  KEY `idx_pickup_date` (`pickup_date`),
  KEY `idx_delivery_date` (`estimated_delivery_date`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `cargo_bookings_ibfk_1` FOREIGN KEY (`sender_customer_id`) REFERENCES `customers` (`customer_id`),
  CONSTRAINT `cargo_bookings_ibfk_2` FOREIGN KEY (`receiver_customer_id`) REFERENCES `customers` (`customer_id`),
  CONSTRAINT `cargo_bookings_ibfk_3` FOREIGN KEY (`sender_address_id`) REFERENCES `customer_addresses` (`address_id`),
  CONSTRAINT `cargo_bookings_ibfk_4` FOREIGN KEY (`receiver_address_id`) REFERENCES `customer_addresses` (`address_id`),
  CONSTRAINT `cargo_bookings_ibfk_5` FOREIGN KEY (`last_status_update_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `customer_addresses`;
CREATE TABLE `customer_addresses` (
  `address_id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int NOT NULL,
  `address_type` enum('home','office','other') NOT NULL,
  `street_address` varchar(255) NOT NULL,
  `city` varchar(100) NOT NULL,
  `state` varchar(100) DEFAULT NULL,
  `postal_code` varchar(20) NOT NULL,
  `country` varchar(100) NOT NULL,
  `is_default` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`address_id`),
  KEY `customer_id` (`customer_id`),
  CONSTRAINT `customer_addresses_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`customer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `customer_enquiries`;
CREATE TABLE `customer_enquiries` (
  `enquiry_id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `enquiry_subject` varchar(255) NOT NULL,
  `enquiry_message` text NOT NULL,
  `enquiry_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('Pending','Resolved','Closed') DEFAULT 'Pending',
  `response_message` text,
  `response_date` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`enquiry_id`),
  KEY `fk_customer_enquiries_customer` (`customer_id`),
  KEY `fk_customer_enquiries_user` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `customers`;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `first_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `phone_number` varchar(20) DEFAULT NULL,
  `passport` varchar(15) DEFAULT NULL,
  `address` text,
  `city` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `email` (`email`),
  KEY `user_id` (`user_id`),
  KEY `idx_customer_email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `delivery_status`;
CREATE TABLE `delivery_status` (
  `status_id` int NOT NULL AUTO_INCREMENT,
  `booking_id` int NOT NULL,
  `status_type` enum('picked_up','in_office','in_transit','arrived_destination','out_for_delivery','delivered','failed_delivery','returned') NOT NULL,
  `location` varchar(255) DEFAULT NULL,
  `status_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `notes` text,
  `updated_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`status_id`),
  KEY `updated_by` (`updated_by`),
  KEY `idx_delivery_booking` (`booking_id`),
  CONSTRAINT `delivery_status_ibfk_1` FOREIGN KEY (`booking_id`) REFERENCES `cargo_bookings` (`booking_id`),
  CONSTRAINT `delivery_status_ibfk_2` FOREIGN KEY (`updated_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `expenses`;
CREATE TABLE `expenses` (
  `expense_id` int NOT NULL AUTO_INCREMENT,
  `expense_type` enum('fuel','maintenance','repairs','insurance','licenses','salaries','rent','utilities','office_supplies','travel','marketing','other') NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `currency` enum('KES','USD') NOT NULL DEFAULT 'KES',
  `description` text,
  `expense_date` date NOT NULL,
  `payment_method` enum('cash','bank_transfer','mobile_money','credit_card','check') NOT NULL,
  `reference_number` varchar(50) DEFAULT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`expense_id`),
  KEY `fk_expenses_user` (`created_by`),
  CONSTRAINT `fk_expenses_user` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `external_api_logs`;
CREATE TABLE `external_api_logs` (
  `log_id` int NOT NULL AUTO_INCREMENT,
  `api_name` varchar(100) NOT NULL,
  `request_data` text,
  `response_data` text,
  `status` enum('Success','Failure') NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `failed_logins`;
CREATE TABLE `failed_logins` (
  `failed_login_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `attempt_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip_address` varchar(45) NOT NULL,
  `user_agent` text NOT NULL,
  PRIMARY KEY (`failed_login_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `family_members`;
CREATE TABLE `family_members` (
  `id` int NOT NULL AUTO_INCREMENT,
  `booking_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `relation` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` enum('Male','Female','Other','') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `age` int NOT NULL,
  `passport_number` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `booking_id` (`booking_id`),
  CONSTRAINT `family_members_ibfk_1` FOREIGN KEY (`booking_id`) REFERENCES `bookings` (`booking_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `fare_rules`;
CREATE TABLE `fare_rules` (
  `id` int NOT NULL AUTO_INCREMENT,
  `rule_name` varchar(50) DEFAULT NULL,
  `discount_type` varchar(20) DEFAULT NULL,
  `discount_value` decimal(10,2) DEFAULT NULL,
  `applicable_classes` varchar(50) DEFAULT NULL,
  `min_stay_days` int DEFAULT NULL,
  `max_stay_days` int DEFAULT NULL,
  `travel_date_from` date DEFAULT NULL,
  `travel_date_to` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `flight_legs`;
CREATE TABLE `flight_legs` (
  `leg_id` int NOT NULL AUTO_INCREMENT,
  `flight_id` int NOT NULL,
  `leg_number` int NOT NULL,
  `origin_id` int NOT NULL,
  `destination_id` int NOT NULL,
  `departure_time` datetime NOT NULL,
  `arrival_time` datetime NOT NULL,
  PRIMARY KEY (`leg_id`),
  KEY `flight_id` (`flight_id`),
  KEY `origin_id` (`origin_id`),
  KEY `destination_id` (`destination_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `flight_patterns`;
CREATE TABLE `flight_patterns` (
  `pattern_id` int NOT NULL AUTO_INCREMENT,
  `flight_number` varchar(50) NOT NULL,
  `origin_id` int NOT NULL,
  `destination_id` int NOT NULL,
  `departure_time` time NOT NULL,
  `arrival_time` time NOT NULL,
  `days_of_week` set('Mon','Tue','Wed','Thu','Fri','Sat','Sun') NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`pattern_id`),
  KEY `origin_id` (`origin_id`),
  KEY `destination_id` (`destination_id`),
  CONSTRAINT `flight_patterns_ibfk_1` FOREIGN KEY (`origin_id`) REFERENCES `airports` (`airport_id`),
  CONSTRAINT `flight_patterns_ibfk_2` FOREIGN KEY (`destination_id`) REFERENCES `airports` (`airport_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `flight_schedules`;
CREATE TABLE `flight_schedules` (
  `schedule_id` int NOT NULL AUTO_INCREMENT,
  `flight_number` varchar(50) NOT NULL,
  `origin_id` int NOT NULL,
  `destination_id` int NOT NULL,
  `departure_time` time NOT NULL,
  `arrival_time` time NOT NULL,
  `days_of_week` set('Mon','Tue','Wed','Thu','Fri','Sat','Sun') NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`schedule_id`),
  KEY `origin_id` (`origin_id`),
  KEY `destination_id` (`destination_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `flights`;
CREATE TABLE `flights` (
  `flight_id` int NOT NULL AUTO_INCREMENT,
  `flight_number` varchar(50) NOT NULL,
  `origin_id` int NOT NULL,
  `destination_id` int NOT NULL,
  `departure_time` datetime NOT NULL,
  `arrival_time` datetime NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `available_seats` int NOT NULL,
  `capacity` int NOT NULL,
  `aircraft_id` int DEFAULT NULL,
  `currency` enum('USD','Ksh.') NOT NULL DEFAULT 'USD',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` enum('scheduled','in progress','completed','cancelled') NOT NULL DEFAULT 'scheduled',
  PRIMARY KEY (`flight_id`),
  KEY `origin_id` (`origin_id`),
  KEY `destination_id` (`destination_id`),
  KEY `aircraft_id` (`aircraft_id`),
  KEY `idx_flight_number` (`flight_number`),
  KEY `idx_departure_time` (`departure_time`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `frequent_flyer_accounts`;
CREATE TABLE `frequent_flyer_accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int NOT NULL,
  `account_number` varchar(20) NOT NULL,
  `points_balance` int DEFAULT '0',
  `tier` enum('Basic','Silver','Gold','Platinum') DEFAULT 'Basic',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`account_id`),
  UNIQUE KEY `account_number` (`account_number`),
  KEY `customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `go_home_service`;
CREATE TABLE `go_home_service` (
  `service_id` int NOT NULL AUTO_INCREMENT,
  `service_date` date NOT NULL,
  `client_name` varchar(255) NOT NULL,
  `mother_name` varchar(255) NOT NULL,
  `date_of_birth` date NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `office_fee` decimal(10,2) NOT NULL,
  `agent_name` varchar(255) NOT NULL,
  `payment_status` enum('paid','unpaid','partial') NOT NULL DEFAULT 'unpaid',
  `currency` enum('USD','KES') NOT NULL DEFAULT 'USD',
  `notes` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int DEFAULT NULL,
  `updated_by` int DEFAULT NULL,
  `reference_number` varchar(50) DEFAULT NULL,
  `status` enum('pending','in_progress','completed','cancelled') NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`service_id`),
  KEY `idx_service_date` (`service_date`),
  KEY `idx_payment_status` (`payment_status`),
  KEY `idx_client_name` (`client_name`),
  KEY `idx_reference_number` (`reference_number`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_updated_by` (`updated_by`),
  CONSTRAINT `fk_go_home_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`) ON DELETE SET NULL,
  CONSTRAINT `fk_go_home_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`user_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `insurance_plans`;
CREATE TABLE `insurance_plans` (
  `plan_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text,
  `price` decimal(10,2) NOT NULL,
  `coverage_details` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`plan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `issues`;
CREATE TABLE `issues` (
  `issue_id` int NOT NULL AUTO_INCREMENT,
  `booking_id` int NOT NULL,
  `reported_by` int NOT NULL,
  `issue_type` enum('delay','damage','loss','other') NOT NULL,
  `description` text NOT NULL,
  `priority` enum('low','medium','high','critical') DEFAULT 'medium',
  `status` enum('open','in_progress','resolved','closed') DEFAULT 'open',
  `assigned_to` int DEFAULT NULL,
  `resolution` text,
  `resolved_date` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`issue_id`),
  KEY `booking_id` (`booking_id`),
  KEY `reported_by` (`reported_by`),
  KEY `assigned_to` (`assigned_to`),
  CONSTRAINT `issues_ibfk_1` FOREIGN KEY (`booking_id`) REFERENCES `cargo_bookings` (`booking_id`),
  CONSTRAINT `issues_ibfk_2` FOREIGN KEY (`reported_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `issues_ibfk_3` FOREIGN KEY (`assigned_to`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications` (
  `notification_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `type` enum('Booking Confirmation','Flight Update','Promotion','Reminder') NOT NULL,
  `content` text NOT NULL,
  `is_read` tinyint(1) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`notification_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `passport_extensions`;
CREATE TABLE `passport_extensions` (
  `extension_id` int NOT NULL AUTO_INCREMENT,
  `extension_date` date NOT NULL,
  `client_name` varchar(255) NOT NULL,
  `country_of_issue` varchar(100) NOT NULL,
  `passport_number` varchar(50) NOT NULL,
  `service_type` enum('extension','renewal','IS','TD') NOT NULL,
  `amount_received` decimal(10,2) NOT NULL,
  `service_payment` decimal(10,2) NOT NULL,
  `agency_fee` decimal(10,2) GENERATED ALWAYS AS ((`amount_received` - `service_payment`)) STORED,
  `payment_status` enum('paid','unpaid','partial') NOT NULL DEFAULT 'unpaid',
  `agent_name` varchar(255) DEFAULT NULL,
  `currency` enum('KES','USD') NOT NULL DEFAULT 'USD',
  `validity_period` int NOT NULL COMMENT 'Number of months extension valid for',
  `expiry_date` date NOT NULL,
  `notes` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int DEFAULT NULL,
  `updated_by` int DEFAULT NULL,
  PRIMARY KEY (`extension_id`),
  KEY `idx_extension_date` (`extension_date`),
  KEY `idx_payment_status` (`payment_status`),
  KEY `idx_passport_number` (`passport_number`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_updated_by` (`updated_by`),
  CONSTRAINT `fk_extensions_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`) ON DELETE SET NULL,
  CONSTRAINT `fk_extensions_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`user_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `password_history`;
CREATE TABLE `password_history` (
  `history_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `old_password` varchar(255) NOT NULL,
  `changed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`history_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets` (
  `reset_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `reset_token` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `used` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`reset_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `payments`;
CREATE TABLE `payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `booking_id` int NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `payment_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `payment_status` enum('Pending','Partial Payment','Completed','Failed') CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT 'Pending',
  `payment_method` enum('Credit Card','PayPal','Bank Transfer') NOT NULL,
  `transaction_id` varchar(255) NOT NULL,
  `payment_gateway` varchar(50) DEFAULT NULL,
  `gateway_transaction_id` varchar(255) DEFAULT NULL,
  `gateway_response` text,
  PRIMARY KEY (`payment_id`),
  KEY `booking_id` (`booking_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `price_history`;
CREATE TABLE `price_history` (
  `history_id` int NOT NULL AUTO_INCREMENT,
  `flight_id` int NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `effective_from` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `effective_to` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`history_id`),
  KEY `flight_id` (`flight_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `promotions`;
CREATE TABLE `promotions` (
  `promotion_id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL,
  `description` text,
  `discount_type` enum('Percentage','Fixed Amount') NOT NULL,
  `discount_value` decimal(10,2) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `usage_limit` int DEFAULT NULL,
  `current_usage` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`promotion_id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `role_permissions`;
CREATE TABLE `role_permissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `role_id` int NOT NULL,
  `permission_key` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `role_permission_unique` (`role_id`,`permission_key`),
  CONSTRAINT `role_permissions_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `user_role` (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `seat_assignments`;
CREATE TABLE `seat_assignments` (
  `assignment_id` int NOT NULL AUTO_INCREMENT,
  `booking_id` int NOT NULL,
  `flight_id` int NOT NULL,
  `seat_number` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`assignment_id`),
  UNIQUE KEY `flight_id` (`flight_id`,`seat_number`),
  KEY `booking_id` (`booking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `session_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `session_token` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_activity` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`session_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(255) NOT NULL,
  `setting_value` text NOT NULL,
  `logo_path` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `support_tickets`;
CREATE TABLE `support_tickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int NOT NULL,
  `subject` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `status` enum('open','in_progress','closed') NOT NULL DEFAULT 'open',
  `priority` enum('low','medium','high','urgent') NOT NULL DEFAULT 'medium',
  `assigned_to` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ticket_number` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`ticket_id`),
  UNIQUE KEY `ticket_number` (`ticket_number`),
  KEY `fk_customer_id` (`customer_id`),
  KEY `fk_assigned_to` (`assigned_to`),
  CONSTRAINT `fk_customer_id` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`customer_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `taxes_and_fees`;
CREATE TABLE `taxes_and_fees` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `tax_type` varchar(20) DEFAULT NULL,
  `value` decimal(10,2) DEFAULT NULL,
  `applicable_airlines` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `ticket_comments`;
CREATE TABLE `ticket_comments` (
  `comment_id` int NOT NULL AUTO_INCREMENT,
  `ticket_id` int NOT NULL,
  `user_id` int NOT NULL,
  `comment` text NOT NULL,
  `is_internal` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`comment_id`),
  KEY `fk_ticket_id` (`ticket_id`),
  KEY `fk_user_id` (`user_id`),
  CONSTRAINT `fk_ticket_id` FOREIGN KEY (`ticket_id`) REFERENCES `support_tickets` (`ticket_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `ticket_details`;
CREATE TABLE `ticket_details` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `salutation` enum('Mr','Mrs','Ms','Dr','Prof') NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `agent_name` varchar(255) DEFAULT NULL,
  `ticket_ref` varchar(50) NOT NULL,
  `booking_class` enum('Y','L','A') CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT 'Y',
  `airline` varchar(50) NOT NULL,
  `flight_route` varchar(20) NOT NULL,
  `flight_date` datetime NOT NULL,
  `ticket_cost` decimal(10,2) NOT NULL,
  `agency_fee` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_amount` decimal(10,2) GENERATED ALWAYS AS ((`ticket_cost` + `agency_fee`)) STORED,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `booking_id` int DEFAULT NULL,
  `status` enum('Active','Cancelled','Used') NOT NULL DEFAULT 'Active',
  `currency` enum('USD','KES') CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT 'USD',
  `created_by` int DEFAULT NULL,
  PRIMARY KEY (`ticket_id`),
  UNIQUE KEY `ticket_ref` (`ticket_ref`),
  KEY `booking_id` (`booking_id`),
  KEY `idx_flight_date` (`flight_date`),
  KEY `idx_customer_name` (`customer_name`),
  KEY `idx_flight_route` (`flight_route`),
  CONSTRAINT `fk_ticket_booking` FOREIGN KEY (`booking_id`) REFERENCES `bookings` (`booking_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

DROP TABLE IF EXISTS `tickets`;
CREATE TABLE `tickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `booking_id` int NOT NULL,
  `ticket_number` varchar(50) NOT NULL,
  `ticket_file_path` varchar(255) NOT NULL,
  `issued_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ticket_id`),
  UNIQUE KEY `ticket_number` (`ticket_number`),
  KEY `booking_id` (`booking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `user_role`;
CREATE TABLE `user_role` (
  `role_id` int NOT NULL,
  `role_name` varchar(50) NOT NULL,
  PRIMARY KEY (`role_id`),
  UNIQUE KEY `role_name` (`role_name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `user_roles`;
CREATE TABLE `user_roles` (
  `user_id` int NOT NULL,
  `role_id` int NOT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `fk_user_roles_role` FOREIGN KEY (`role_id`) REFERENCES `user_role` (`role_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` int NOT NULL,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `user_role` enum('admin','general_manager','operations','finance','declaration_officer','shipping_line_clerk','transport_supervisor') DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `verified` tinyint DEFAULT '1',
  `failed_attempts` int NOT NULL DEFAULT '0',
  `last_attempt_time` timestamp NULL DEFAULT NULL,
  `last_password_change` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `role_id` int DEFAULT NULL,
  `last_active` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `fk_users_role` FOREIGN KEY (`role_id`) REFERENCES `user_role` (`role_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `visa_applications`;
CREATE TABLE `visa_applications` (
  `application_id` int NOT NULL AUTO_INCREMENT,
  `client_name` varchar(100) NOT NULL,
  `agent_name` varchar(255) DEFAULT NULL,
  `reference_number` varchar(50) NOT NULL,
  `care_of` varchar(100) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `payment` decimal(10,2) NOT NULL,
  `commission` decimal(10,2) GENERATED ALWAYS AS ((`amount` - `payment`)) STORED,
  `currency` enum('KES','USD') NOT NULL DEFAULT 'USD',
  `status` enum('Pending','Processing','Completed','Cancelled') NOT NULL DEFAULT 'Pending',
  `notes` text,
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`application_id`),
  UNIQUE KEY `reference_number` (`reference_number`),
  KEY `created_by` (`created_by`),
  KEY `updated_by` (`updated_by`),
  KEY `idx_status` (`status`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `fk_visa_created_by` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`),
  CONSTRAINT `fk_visa_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO `admin_logs` VALUES
('1', '1', 'company_create', 'Company: Saroze Soutions (ID: 2)', '102.140.245.174', '2024-12-29 19:12:44'),
('2', '1', 'company_suspend', 'Company: Saroze Soutions (ID: 2)', '102.140.245.174', '2024-12-29 19:17:25'),
('3', '1', 'company_activate', 'Company: Saroze Soutions (ID: 2)\nChanges:\nstatus: suspended → active', '102.140.245.174', '2024-12-29 19:17:48'),
('4', '1', 'config_change', 'Component: backup\nCreated database backup: backup_2024-12-29_19-27-14.sql', '102.140.245.174', '2024-12-29 19:27:14'),
('5', '1', 'config_change', 'Component: backup_delete\nDeleted backup file: backup_2024-12-29_19-27-14.sql', '102.140.245.174', '2024-12-29 19:27:27'),
('6', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2024-12-29_19-39-50.sql', '102.140.245.174', '2024-12-29 19:39:50'),
('7', '1', 'config_change', 'Component: backup_download\nDownloaded backup file: backup_2024-12-29_19-39-50.sql', '102.140.245.174', '2024-12-29 19:40:01'),
('8', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2024-12-29_19-43-19.sql', '102.140.245.174', '2024-12-29 19:43:19'),
('9', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2024-12-29_19-49-17.sql', '102.140.245.174', '2024-12-29 19:49:17'),
('10', '1', 'config_change', 'Component: backup_delete\nDeleted backup file: backup_2024-12-29_19-49-17.sql', '102.140.245.174', '2024-12-29 19:50:31'),
('11', '1', 'config_change', 'Component: backup_delete\nDeleted backup file: backup_2024-12-29_19-39-50.sql', '102.140.245.174', '2024-12-29 19:50:35'),
('12', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2024-12-29_19-50-38.sql', '102.140.245.174', '2024-12-29 19:50:38'),
('13', '1', 'config_change', 'Component: backup_settings\nUpdated backup schedule settings', '102.140.245.174', '2024-12-29 19:50:53'),
('14', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2025-01-03_18-24-30.sql', '102.140.245.174', '2025-01-03 18:24:30'),
('15', '1', 'config_change', 'Component: backup\nCreated manual backup: backup_2025-01-03_18-35-25.sql', '102.140.245.174', '2025-01-03 21:35:25'),
('16', '1', 'config_change', 'Component: backup_delete\nDeleted backup file: backup_2025-01-03_18-31-52.sql', '102.140.245.174', '2025-01-03 21:35:49'),
('17', '1', 'config_change', 'Component: backup_delete\nDeleted backup file: backup_2025-01-03_18-34-49.sql', '102.140.245.174', '2025-01-03 21:36:01'),
('18', '1', 'config_change', 'Component: backup_delete\nDeleted backup file: backup_2025-01-03_18-35-25.sql', '102.140.245.174', '2025-01-03 21:36:10');


INSERT INTO `airports` VALUES
('1', 'DXB', 'Dubai International Airport', 'Dubai', 'United Arab Emirates', '25.253200', '55.365700', '62'),
('2', 'LHR', 'London Heathrow Airport', 'London', 'United Kingdom', '51.470000', '-0.454300', '83'),
('3', 'AMS', 'Amsterdam Airport Schiphol', 'Amsterdam', 'Netherlands', '52.307600', '4.767600', '-11'),
('4', 'CDG', 'Paris Charles de Gaulle Airport', 'Paris', 'France', '49.009700', '2.547900', '392'),
('5', 'JNB', 'Johannesburg O.R. Tambo International Airport', 'Johannesburg', 'South Africa', '-26.136700', '28.242500', '5558'),
('6', 'ADD', 'Addis Ababa Bole International Airport', 'Addis Ababa', 'Ethiopia', '8.977800', '38.799900', '7625'),
('7', 'BOM', 'Mumbai Chhatrapati Shivaji Maharaj International Airport', 'Mumbai', 'India', '19.089600', '72.865600', '39'),
('8', 'CAN', 'Guangzhou Baiyun International Airport', 'Guangzhou', 'China', '23.392400', '113.298800', '50'),
('9', 'JFK', 'New York John F. Kennedy International Airport', 'New York City', 'USA', '40.641300', '-73.778100', '13'),
('10', 'DOH', 'Doha Hamad International Airport', 'Doha', 'Qatar', '25.273600', '51.608600', '13'),
('11', 'BKK', 'Bangkok Suvarnabhumi Airport', 'Bangkok', 'Thailand', '13.690000', '100.750100', '5'),
('12', 'IST', 'Istanbul Airport', 'Istanbul', 'Turkey', '41.275100', '28.751900', '325'),
('13', 'EBB', 'Entebbe International Airport', 'Entebbe', 'Uganda', '0.042300', '32.443500', '3782'),
('14', 'DAR', 'Julius Nyerere International Airport', 'Dar es Salaam', 'Tanzania', '-6.878500', '39.202600', '182'),
('15', 'KGL', 'Kigali International Airport', 'Kigali', 'Rwanda', '-1.968600', '30.194500', '4859'),
('16', 'BJM', 'Bujumbura International Airport', 'Bujumbura', 'Burundi', '-3.324000', '29.318500', '2582'),
('17', 'FIH', 'Kinshasa N\'djili Airport', 'Kinshasa', 'Democratic Republic of the Congo', '-4.385700', '15.444600', '1027'),
('18', 'CAI', 'Cairo International Airport', 'Cairo', 'Egypt', '30.121900', '31.405600', '382'),
('19', 'FRA', 'Frankfurt Airport', 'Frankfurt', 'Germany', '50.037900', '8.562200', '364'),
('20', 'JED', 'Jeddah King Abdulaziz International Airport', 'Jeddah', 'Saudi Arabia', '21.680500', '39.172200', '48'),
('21', 'HRE', 'Harare Robert Gabriel Mugabe International Airport', 'Harare', 'Zimbabwe', '-17.931800', '31.092800', '4887'),
('22', 'LUN', 'Lusaka Kenneth Kaunda International Airport', 'Lusaka', 'Zambia', '-15.330800', '28.452600', '3779'),
('23', 'SEZ', 'Seychelles International Airport', 'Victoria', 'Seychelles', '-4.674200', '55.521700', '10'),
('24', 'MRU', 'Mauritius Sir Seewoosagur Ramgoolam International Airport', 'Port Louis', 'Mauritius', '-20.430200', '57.683600', '186'),
('25', 'SIN', 'Singapore Changi Airport', 'Singapore', 'Singapore', '1.364400', '103.991500', '22'),
('26', 'PEK', 'Beijing Capital International Airport', 'Beijing', 'China', '40.079900', '116.603100', '116'),
('27', 'YYZ', 'Toronto Pearson International Airport', 'Toronto', 'Canada', '43.677700', '-79.624800', '569'),
('28', 'MBA', 'Moi International Airport Mombasa', 'Mombasa', 'Kenya', '-4.035200', '39.594400', '200'),
('29', 'ZNZ', 'Zanzibar Abeid Amani Karume International Airport', 'Zanzibar City', 'Tanzania', '-6.222000', '39.224900', '54'),
('30', 'MGQ', 'Mogadishu Aden Adde International Airport', 'Mogadishu', 'Somalia', '2.014400', '45.304700', '29'),
('31', 'LOS', 'Murtala Muhammed International Airport', 'Lagos', 'Nigeria', '6.577400', '3.321200', '135'),
('32', 'ABV', 'Nnamdi Azikiwe International Airport', 'Abuja', 'Nigeria', '9.006500', '7.263000', '1123'),
('33', 'JUB', 'Juba International Airport', 'Juba', 'South Sudan', '4.872500', '31.601100', '1513'),
('34', 'YVR', 'Vancouver International Airport', 'Vancouver', 'Canada', '49.196700', '-123.181500', '14'),
('35', 'BAH', 'Bahrain International Airport', 'Manama', 'Bahrain', '26.270800', '50.633200', '6'),
('36', 'HGA', 'Egal International Airport', 'Hargeisa', 'Somalia', '9.518200', '44.082400', '4423'),
('37', 'YUL', 'Montreal-Pierre Elliott Trudeau International Airport', 'Montreal', 'Canada', '45.470600', '-73.740700', '118'),
('38', 'YYC', 'Calgary International Airport', 'Calgary', 'Canada', '51.131400', '-114.010400', '3557'),
('39', 'KMU', 'Kismayo Airport', 'Kismayo', 'Somalia', '-0.377800', '42.459200', '49'),
('40', 'PHC', 'Port Harcourt International Airport', 'Port Harcourt', 'Nigeria', '5.015900', '6.949500', '87'),
('41', 'NBO', 'Jomo Kenyatta International Airport', 'Nairobi', 'Kenya', '-1.333731', '36.927109', '5272'),
('42', 'AAL', 'Aalborg Airport', 'Aalborg', 'Denmark', '57.086435', '9.868076', '19'),
('43', 'ASV', 'Amboseli Airport', 'Amboseli', 'Kenya', '-2.645326', '37.248579', '3694');

INSERT INTO `audit_logs` VALUES
('1', '1', 'CREATE_EXTENSION', 'Created passport extension for Sam', '2025-01-03 13:32:54', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0'),
('2', '1', 'CREATE_EXTENSION', 'Created passport extension for Sam', '2025-01-03 13:34:49', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0'),
('3', '1', 'CREATE_EXTENSION', 'Created passport extension for Sam', '2025-01-03 13:36:29', '102.140.245.174', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:133.0) Gecko/20100101 Firefox/133.0'),
('4', '1', 'CREATE_VISA', 'Created visa application for Sam NK', '2025-04-17 14:26:29', '102.217.120.14', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:124.0) Gecko/20100101 Firefox/124.0'),
('5', '1', 'CREATE_EXTENSION', 'Created passport extension for Sam NK', '2025-04-17 14:33:54', '102.217.120.14', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:124.0) Gecko/20100101 Firefox/124.0'),
('6', '1', 'CANCEL_TICKET', 'Cancelled ticket reference: TST001', '2025-05-04 17:56:44', '41.90.177.106', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:136.0) Gecko/20100101 Firefox/136.0'),
('7', '1', 'CREATE_VISA', 'Created visa application for Test', '2025-05-05 12:57:17', '102.217.120.14', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36');

INSERT INTO `backup_settings` VALUES
('1', 'backup_frequency', 'daily', '2024-12-29 19:35:13', '2024-12-29 19:35:13'),
('2', 'retention_days', '30', '2024-12-29 19:35:13', '2024-12-29 19:35:13'),
('3', 'notify_email', 'hi@myne.co.ke', '2024-12-29 19:35:13', '2024-12-29 19:50:53'),
('4', 'last_backup_time', '', '2024-12-29 19:35:13', '2024-12-29 19:35:13'),
('5', 'backup_enabled', '1', '2024-12-29 19:35:13', '2024-12-29 19:35:13');


INSERT INTO `booking_code_sequence` VALUES
('1', '5');




INSERT INTO `cargo_bookings` VALUES
('1', 'AWT000001', '3', '3', '4', '2', 'Danny  Mond', '+254798805300', 'test@test.com', 'electronics', '5.00', NULL, '30 x 20 x 15', 'Keep safe', 'delivered', 'paid', '2024-12-02 09:50:18', '2024-12-02 00:00:00', '2024-12-06', '2024-12-02 14:21:52', '120.00', 'USD', '120.00', '0', NULL, '2024-12-02 14:21:52', '1', 'Customer satisfied with the delivery', '2024-12-02 09:50:18', '2024-12-02 14:21:52', '2024-12-02 09:52:16'),
('2', 'AWT000002', '3', '3', '4', '2', 'Danny  Mond', '+254798805300', 'test@test.com', 'general', '10.00', '4', '', 'Fragile', 'pending', 'paid', '2025-04-17 13:57:31', '2025-04-19 00:00:00', '2025-04-20', NULL, '40.00', 'USD', '40.00', '0', NULL, NULL, NULL, NULL, '2025-04-17 13:57:31', '2025-04-17 13:58:44', '2025-04-17 13:58:44'),
('3', 'AWT000003', '4', '2', '3', '3', 'Sam N', '+254705004039', 'sharcyville@gmail.com', 'documents', '10.00', '3', '', '', 'confirmed', 'paid', '2025-05-05 13:03:19', '2025-05-06 00:00:00', '2025-05-08', NULL, '30.00', 'USD', '50.00', '0', NULL, '2025-05-05 13:05:02', '1', '', '2025-05-05 13:03:19', '2025-05-05 13:05:02', '2025-05-05 13:04:05');

INSERT INTO `customer_addresses` VALUES
('2', '4', 'home', 'KP Flats', 'Mogadishu', '', '000000', 'SO', '1', '2024-12-02 09:43:17', '2024-12-02 09:49:23'),
('3', '3', 'home', 'K.P Flats', 'Nairobi', 'RV', '00100', 'KE', '1', '2024-11-20 16:56:52', '2024-11-20 16:58:24');


INSERT INTO `customers` VALUES
('3', '1', 'Sam', 'N', 'sharcyville@gmail.com', '+254705004039', 'AK001002', 'Nairobi', 'Nairobi', 'Kenya', '2024-09-16 13:42:31', '2024-11-26 08:30:44'),
('4', '1', 'Danny ', 'Mond', 'test@test.com', '+254798805300', NULL, 'KP Flats', 'Mogadishu', 'KE', '2024-12-02 09:43:17', '2024-12-02 09:43:17');


INSERT INTO `expenses` VALUES
('1', 'salaries', '1000.00', 'KES', 'Paid Sam', '2025-04-17', 'cash', '', '1', '2025-04-17 14:47:35', '2025-04-17 14:47:35');






INSERT INTO `flight_patterns` VALUES
('1', 'NK001', '41', '33', '09:00:00', '11:00:00', 'Mon,Wed,Fri', '2024-09-27', '2025-03-27', '2024-09-27 07:21:06', '2024-09-27 07:21:06');

INSERT INTO `flight_schedules` VALUES
('1', 'OAL001', '41', '33', '09:00:00', '10:45:00', 'Tue,Thu,Sat', '2024-09-30', '2025-03-27', '2024-09-13 10:27:01', '2024-09-27 07:25:39'),
('2', 'OAL002', '41', '33', '09:00:00', '10:45:00', 'Tue,Thu,Sat', '2024-09-28', '2025-03-27', '2024-09-13 07:27:01', '2024-09-27 07:25:44'),
('3', 'NEW001', '15', '26', '09:00:00', '11:00:00', 'Mon,Wed,Fri', '2024-09-27', '2025-09-27', '2024-09-27 07:18:04', '2024-09-27 07:18:04'),
('5', 'IFA757', '33', '41', '10:45:00', '12:00:00', 'Mon,Tue,Wed,Thu', '2024-09-28', '2024-10-05', '2024-09-27 16:34:39', '2024-09-27 16:34:39');

INSERT INTO `flights` VALUES
('1', 'OAL001', '41', '33', '2024-09-17 09:45:00', '2024-09-17 10:45:00', '300.00', '33', '34', NULL, 'USD', '2024-09-13 10:32:09', '2024-11-26 08:33:01', 'completed'),
('2', 'IFA757', '41', '30', '2024-10-11 07:45:00', '2024-10-11 10:45:00', '350.00', '49', '100', NULL, 'USD', '2024-09-27 15:40:35', '2024-11-26 08:27:43', 'scheduled'),
('3', 'OAL002', '41', '33', '2024-10-13 08:00:00', '2024-10-13 09:45:00', '300.00', '46', '100', NULL, 'USD', '2024-09-27 15:48:07', '2024-10-12 16:45:37', 'scheduled'),
('4', 'OAL001', '41', '30', '2024-10-19 07:00:00', '2024-10-19 09:00:00', '400.00', '33', '100', NULL, 'USD', '2024-10-17 12:56:55', '2024-11-26 08:50:42', 'scheduled');


INSERT INTO `go_home_service` VALUES
('2', '2025-05-05', 'Test', 'Tester', '1990-03-21', '200.00', '30.00', 'ADMIN', 'paid', 'USD', '', '2025-05-05 12:44:58', '2025-05-05 12:45:51', NULL, NULL, 'GHO00001', 'completed');










INSERT INTO `role_permissions` VALUES
('1', '1', 'dashboard', '2024-12-07 07:45:15'),
('2', '1', 'cargo_management', '2024-12-07 07:45:15'),
('3', '1', 'bookings_management', '2024-12-07 07:45:15'),
('4', '1', 'customers_management', '2024-12-07 07:45:15'),
('5', '1', 'user_management', '2024-12-07 07:45:15'),
('6', '1', 'payments_management', '2024-12-07 07:45:15'),
('7', '1', 'expense_management', '2024-12-07 07:45:15'),
('8', '1', 'ticket_management', '2024-12-07 07:45:15'),
('9', '1', 'reports_management', '2024-12-07 07:45:15'),
('10', '1', 'flight_management', '2024-12-07 07:45:15'),
('11', '1', 'system_settings', '2024-12-07 07:45:15');



INSERT INTO `settings` VALUES
('1', 'system_name', 'African Wings Travel & Cargo Ltd', NULL),
('2', 'email_host', 'your_email_host', NULL),
('3', 'email_port', 'your_email_port', NULL),
('4', 'email_username', 'your_email_username', NULL),
('5', 'email_password', 'your_email_password', NULL),
('6', 'email_sender', 'your_email_sender', NULL),
('7', 'default_currency', 'USD', NULL),
('8', 'address', 'Opp Open Cafe Restaurant Eastleigh, Nairobi', NULL),
('9', 'tel_1', '+254 711 234 567', NULL),
('10', 'tel_2', '+254 700 234 567', NULL);

INSERT INTO `support_tickets` VALUES
('1', '3', 'Testing', 'Testing. Remember to adapt this template to fit your specific needs and design. Also, ensure that you have proper validation, error handling, and security measures in place when processing the form submission.', 'open', 'urgent', NULL, '2024-10-17 20:46:43', '2024-10-18 14:34:32', 'CRS001');



INSERT INTO `ticket_details` VALUES
('8', 'Mr', 'TEst', 'ADMIN', 'TST001', 'Y', 'iFly Air', 'NBO-JUB', '2025-05-05 10:00:00', '300.00', '20.00', '320.00', '2025-05-04 17:50:11', '2025-05-04 17:56:44', NULL, 'Cancelled', '', '1'),
('9', 'Mr', 'Ahmed', 'SHUEB', 'TST0X01', 'Y', 'iFly Air', 'NBO-JUB', '2025-05-06 10:46:00', '300.00', '20.00', '320.00', '2025-05-05 12:49:57', '2025-05-05 12:49:57', NULL, 'Active', '', NULL),
('10', 'Mr', 'Ahmed B', 'SHUEB', 'TSTS001', 'L', 'iFly Air', 'NBO-JUB', '2025-05-07 11:10:00', '300.00', '20.00', '320.00', '2025-05-05 12:55:07', '2025-05-05 12:55:07', NULL, 'Active', '', NULL);


INSERT INTO `user_role` VALUES
('1', 'Administrator'),
('5', 'Employee'),
('4', 'Finance'),
('2', 'General Manager'),
('3', 'Operations');

INSERT INTO `user_roles` VALUES
('1', '1'),
('19', '1'),
('20', '1'),
('12', '2'),
('11', '3'),
('0', '4'),
('13', '5'),
('14', '5');

INSERT INTO `users` VALUES
('0', 'sharcy', 'nujoma@polakis.co.ke', 'Sharcy Test', '$2y$10$.lYBYtiSH8UN1TGfqPCMLO7qvHZzeprPXcwVRUYp4eUUGuV.cycce', 'finance', '2025-01-05 10:49:56', '1', '0', NULL, '2025-01-05 10:49:56', '4', '2025-01-05 10:50:27'),
('1', 'Admin', 'hi@myne.co.ke', 'AWT Admin', '$2y$10$Y.5OCS473Vc4NjnwwvU//eLkhc4LP2rBy/2Y9Qqjf0Ai1TB7ItWzi', 'admin', '2023-09-17 07:48:54', '1', '3', '2024-02-11 10:07:14', '2024-07-12 07:15:55', '1', '2025-05-05 12:44:05');

INSERT INTO `visa_applications` VALUES
('2', 'Test', 'SHUEB', 'RCF001', NULL, '400.00', '300.00', '100.00', 'USD', 'Pending', '', '1', '2025-05-05 12:57:17', NULL, '2025-05-05 12:57:17');


SET FOREIGN_KEY_CHECKS=1;
