<?php
include 'layouts/main.php';
include 'layouts/dbconn.php';

// Check if the user is not logged in
/*if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}*/

// Handle search
$search = isset($_GET['search']) ? $_GET['search'] : '';
$dateFrom = isset($_GET['date_from']) ? $_GET['date_from'] : '';
$dateTo = isset($_GET['date_to']) ? $_GET['date_to'] : '';
$status = isset($_GET['status']) ? $_GET['status'] : '';

$query = "SELECT ghs.*, u_created.full_name as created_by_name, u_updated.full_name as updated_by_name
          FROM go_home_service ghs
          LEFT JOIN users u_created ON ghs.created_by = u_created.user_id
          LEFT JOIN users u_updated ON ghs.updated_by = u_updated.user_id
          WHERE 1=1";

$params = [];
$types = "";

if (!empty($search)) {
    $query .= " AND (ghs.client_name LIKE ? OR ghs.mother_name LIKE ? OR ghs.agent_name LIKE ? OR ghs.reference_number LIKE ?)";
    $searchParam = "%$search%";
    $params = array_merge($params, [$searchParam, $searchParam, $searchParam, $searchParam]);
    $types .= "ssss";
}

if (!empty($dateFrom)) {
    $query .= " AND ghs.service_date >= ?";
    $params[] = $dateFrom;
    $types .= "s";
}

if (!empty($dateTo)) {
    $query .= " AND ghs.service_date <= ?";
    $params[] = $dateTo;
    $types .= "s";
}

if (!empty($status)) {
    $query .= " AND ghs.status = ?";
    $params[] = $status;
    $types .= "s";
}

$query .= " ORDER BY ghs.created_at DESC";

$stmt = $conn->prepare($query);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'All Go Home Services')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <link href="assets/libs/datatables/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="assets/libs/datatables/responsive.bootstrap5.min.css" rel="stylesheet">
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Services', 'title' => 'All Go Home Services')); ?>

                    <?php if (isset($_SESSION['success_message'])): ?>
                        <div class="alert alert-success alert-dismissible">
                            <?php echo $_SESSION['success_message']; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                        <?php unset($_SESSION['success_message']); ?>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center">
                                        <div class="col">
                                            <h4 class="card-title mb-0">Go Home Services</h4>
                                        </div>
                                        <div class="col-auto">
                                            <a href="add_go_home.php" class="btn btn-primary">
                                                <i class="ri-add-line align-bottom me-1"></i> Add New Service
                                            </a>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-body">
                                    <form method="GET" class="row g-3 mb-4">
                                        <div class="col-md-3">
                                            <input type="text" class="form-control" name="search" placeholder="Search..." value="<?php echo htmlspecialchars($search); ?>">
                                        </div>
                                        <div class="col-md-2">
                                            <input type="date" class="form-control" name="date_from" value="<?php echo htmlspecialchars($dateFrom); ?>">
                                        </div>
                                        <div class="col-md-2">
                                            <input type="date" class="form-control" name="date_to" value="<?php echo htmlspecialchars($dateTo); ?>">
                                        </div>
                                        <div class="col-md-2">
                                            <select class="form-select" name="status">
                                                <option value="">All Status</option>
                                                <option value="pending" <?php echo $status == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                                <option value="in_progress" <?php echo $status == 'in_progress' ? 'selected' : ''; ?>>In Progress</option>
                                                <option value="completed" <?php echo $status == 'completed' ? 'selected' : ''; ?>>Completed</option>
                                                <option value="cancelled" <?php echo $status == 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <button type="submit" class="btn btn-primary me-2">Search</button>
                                            <a href="all_go_home.php" class="btn btn-secondary">Reset</a>
                                        </div>
                                    </form>

                                    <div class="table-responsive">
                                        <table id="go-home-table" class="table table-bordered dt-responsive nowrap table-striped align-middle">
                                            <thead>
                                                <tr>
                                                    <th>Reference</th>
                                                    <th>Date</th>
                                                    <th>Client Name</th>
                                                    <th>Mother's Name</th>
                                                    <th>DOB</th>
                                                    <th>Price</th>
                                                    <th>Office Fee</th>
                                                    <th>Agent</th>
                                                    <th>Payment Status</th>
                                                    <th>Status</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php while ($row = $result->fetch_assoc()): ?>
                                                    <tr>
                                                        <td><?php echo htmlspecialchars($row['reference_number']); ?></td>
                                                        <td><?php echo date('d M Y', strtotime($row['service_date'])); ?></td>
                                                        <td><?php echo htmlspecialchars($row['client_name']); ?></td>
                                                        <td><?php echo htmlspecialchars($row['mother_name']); ?></td>
                                                        <td><?php echo date('d M Y', strtotime($row['date_of_birth'])); ?></td>
                                                        <td><?php echo $row['currency'] . ' ' . number_format($row['price'], 2); ?></td>
                                                        <td><?php echo $row['currency'] . ' ' . number_format($row['office_fee'], 2); ?></td>
                                                        <td><?php echo htmlspecialchars($row['agent_name']); ?></td>
                                                        <td>
                                                            <span class="badge bg-<?php 
                                                                echo $row['payment_status'] == 'paid' ? 'success' : 
                                                                    ($row['payment_status'] == 'partial' ? 'warning' : 'danger'); 
                                                            ?>">
                                                                <?php echo ucfirst($row['payment_status']); ?>
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <span class="badge bg-<?php 
                                                                echo $row['status'] == 'completed' ? 'success' : 
                                                                    ($row['status'] == 'in_progress' ? 'info' : 
                                                                    ($row['status'] == 'cancelled' ? 'danger' : 'secondary')); 
                                                            ?>">
                                                                <?php echo ucfirst(str_replace('_', ' ', $row['status'])); ?>
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <div class="dropdown">
                                                                <button class="btn btn-soft-secondary btn-sm dropdown-toggle" data-bs-toggle="dropdown">
                                                                    <i class="ri-more-2-fill align-middle"></i>
                                                                </button>
                                                                <ul class="dropdown-menu dropdown-menu-end">
                                                                    <li>
                                                                        <a class="dropdown-item" href="view_go_home.php?id=<?php echo $row['service_id']; ?>">
                                                                            <i class="ri-eye-fill align-bottom me-2 text-muted"></i> View
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a class="dropdown-item" href="edit_go_home.php?id=<?php echo $row['service_id']; ?>">
                                                                            <i class="ri-edit-box-fill align-bottom me-2 text-muted"></i> Edit
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a class="dropdown-item" href="print_go_home.php?id=<?php echo $row['service_id']; ?>">
                                                                            <i class="ri-printer-fill align-bottom me-2 text-muted"></i> Print
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php endwhile; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
    <script src="assets/libs/datatables/dataTables.bootstrap5.min.js"></script>
    <script src="assets/libs/datatables/responsive.bootstrap5.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#go-home-table').DataTable({
                "paging": true,
                "searching": false,
                "ordering": true,
                "responsive": true,
                "pageLength": 25,
                "order": [[ 0, "desc" ]]
            });
        });
    </script>
</body>
</html>