<?php
include 'layouts/session.php';
include 'layouts/main.php';
include 'layouts/dbconn.php';

// Fetch staff members for dropdown
$staffQuery = "SELECT staff_id, full_name FROM staff WHERE status = 'active' ORDER BY full_name";
$staffMembers = $conn->query($staffQuery)->fetch_all(MYSQLI_ASSOC);
?>

<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg">
<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Add Visa Application')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- Visa Application Form -->
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">New Visa Application</h4>
                                </div>
                                <div class="card-body">
                                    <form id="visaForm" method="POST" action="save_visa.php">
                                        <div class="row gy-3">
                                            <!-- Client Information -->
                                            <div class="col-md-6">
                                                <label class="form-label">Client Name</label>
                                                <input type="text" class="form-control" name="client_name" required>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label" for="staff_id">Staff</label>
                                                <select class="form-select" id="staff_id" name="staff_id" required>
                                                    <option value="">Select Staff</option>
                                                    <?php foreach ($staffMembers as $staff): ?>
                                                        <option value="<?php echo $staff['staff_id']; ?>">
                                                            <?php echo htmlspecialchars($staff['full_name']); ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <div class="invalid-feedback">
                                                    Please select a staff member.
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label">Reference Number</label>
                                                <input type="text" class="form-control" name="reference_number" required>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label">Care Of (Optional)</label>
                                                <input type="text" class="form-control" name="care_of" placeholder="Leave blank if not applicable">
                                            </div>

                                            <!-- Payment Details -->
                                            <div class="col-md-4">
                                                <label class="form-label">Currency</label>
                                                <select class="form-select" name="currency" id="currency" required>
                                                    <option value="USD">US Dollar (USD)</option>
                                                    <option value="KES">Kenya Shilling (KES)</option>
                                                </select>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label">Processing Amount</label>
                                                <div class="input-group">
                                                    <span class="input-group-text currency-symbol">USD</span>
                                                    <input type="number" step="0.01" class="form-control" 
                                                           id="amount" name="amount" required>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label">Payment Received</label>
                                                <div class="input-group">
                                                    <span class="input-group-text currency-symbol">USD</span>
                                                    <input type="number" step="0.01" class="form-control" 
                                                           id="payment" name="payment" required>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label">Agency Commission</label>
                                                <div class="input-group">
                                                    <span class="input-group-text currency-symbol">USD</span>
                                                    <input type="number" step="0.01" class="form-control" 
                                                           id="commission" readonly>
                                                </div>
                                            </div>

                                            <!-- Additional Information -->
                                            <div class="col-12">
                                                <label class="form-label">Notes</label>
                                                <textarea class="form-control" name="notes" rows="3" placeholder="Enter any additional notes or comments here..."></textarea>
                                            </div>

                                            <!-- Submit Button -->
                                            <div class="col-12">
                                                <button type="submit" class="btn btn-primary">
                                                    Save Application
                                                </button>
                                                <a href="all_visas.php" class="btn btn-secondary">Cancel</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>
    <script src="assets/js/app.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    
    <script>
    // Initialize Select2 for staff dropdown
    $(document).ready(function() {
        $('#staff_id').select2({
            placeholder: "Select Staff",
            allowClear: true
        });
    });

    document.getElementById('visaForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);

        fetch('save_visa.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                Swal.fire({
                    title: 'Success!',
                    text: data.message,
                    icon: 'success',
                    confirmButtonText: 'OK'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = 'all_visas.php';
                    }
                });
            } else {
                Swal.fire({
                    title: 'Error!',
                    text: data.message,
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({
                title: 'Error!',
                text: 'An error occurred while saving the application.',
                icon: 'error',
                confirmButtonText: 'OK'
            });
        });
    });
    </script>
    
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const currencySelect = document.getElementById('currency');
        const currencySymbols = document.querySelectorAll('.currency-symbol');
        const amountInput = document.getElementById('amount');
        const paymentInput = document.getElementById('payment');
        const commissionInput = document.getElementById('commission');

        function updateCurrencySymbols() {
            const selectedCurrency = currencySelect.value;
            currencySymbols.forEach(symbol => {
                symbol.textContent = selectedCurrency;
            });
        }

        function calculateCommission() {
            const amount = parseFloat(amountInput.value) || 0;
            const payment = parseFloat(paymentInput.value) || 0;
            const commission = amount - payment;
            commissionInput.value = commission.toFixed(2);
        }

        currencySelect.addEventListener('change', updateCurrencySymbols);
        amountInput.addEventListener('input', calculateCommission);
        paymentInput.addEventListener('input', calculateCommission);

        // Initialize
        updateCurrencySymbols();
    });
    </script>
</body>
</html>