<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Add Staff')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Staff Management', 'title' => 'Add New Staff')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Add Staff Member</h4>
                                </div>
                                <div class="card-body">
                                    <form method="POST" action="save_staff.php">
                                        <div class="row gy-4">
                                            <!-- Personal Information -->
                                            <div class="col-12">
                                                <h5 class="text-muted mb-3">Personal Information</h5>
                                            </div>
                                            
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="employeeId" class="form-label">Employee ID</label>
                                                    <input type="text" class="form-control" id="employeeId" name="employee_id" required>
                                                </div>
                                            </div>
                                            
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="fullName" class="form-label">Full Name</label>
                                                    <input type="text" class="form-control" id="fullName" name="full_name" required>
                                                </div>
                                            </div>
                                            
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="email" class="form-label">Email</label>
                                                    <input type="email" class="form-control" id="email" name="email" required>
                                                </div>
                                            </div>
                                            
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="phone" class="form-label">Phone Number</label>
                                                    <input type="tel" class="form-control" id="phone" name="phone">
                                                </div>
                                            </div>
                                            
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="dateHired" class="form-label">Date Hired</label>
                                                    <input type="date" class="form-control" id="dateHired" name="date_hired">
                                                </div>
                                            </div>

                                            <!-- Employment Information -->
                                            <div class="col-12 mt-4">
                                                <h5 class="text-muted mb-3">Employment Information</h5>
                                            </div>
                                            
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="department" class="form-label">Department</label>
                                                    <select class="form-select" id="department" name="department">
                                                        <option value="">Select Department</option>
                                                        <option value="Operations">Operations</option>
                                                        <option value="Finance">Finance</option>
                                                        <option value="Customer Service">Customer Service</option>
                                                        <option value="Cargo">Cargo</option>
                                                        <option value="Administration">Administration</option>
                                                        <option value="Marketing">Marketing</option>
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="position" class="form-label">Position</label>
                                                    <input type="text" class="form-control" id="position" name="position">
                                                </div>
                                            </div>
                                            
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="status" class="form-label">Status</label>
                                                    <select class="form-select" id="status" name="status">
                                                        <option value="active">Active</option>
                                                        <option value="inactive">Inactive</option>
                                                        <option value="suspended">Suspended</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <!-- Contact Information -->
                                            <div class="col-12 mt-4">
                                                <h5 class="text-muted mb-3">Contact Information</h5>
                                            </div>
                                            
                                            <div class="col-md-6">
                                                <div>
                                                    <label for="address" class="form-label">Address</label>
                                                    <textarea class="form-control" id="address" name="address" rows="3"></textarea>
                                                </div>
                                            </div>
                                            
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="city" class="form-label">City</label>
                                                    <input type="text" class="form-control" id="city" name="city">
                                                </div>
                                            </div>
                                            
                                            <div class="col-xxl-3 col-md-6">
                                                <div>
                                                    <label for="country" class="form-label">Country</label>
                                                    <input type="text" class="form-control" id="country" name="country">
                                                </div>
                                            </div>

                                            <!-- Submit Button -->
                                            <div class="col-12 mt-4">
                                                <button type="submit" class="btn btn-success btn-label waves-effect waves-light rounded-pill">
                                                    <i class="ri-check-double-line label-icon align-middle rounded-pill fs-16 me-2"></i> 
                                                    Save Staff Member
                                                </button>
                                                <a href="all_staff.php" class="btn btn-secondary waves-effect waves-light rounded-pill">
                                                    Cancel
                                                </a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
</body>
</html>