<?php
include 'layouts/main.php';
include 'layouts/dbconn.php';

// Check if the user is not logged in
/*if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}*/

$user_id = $_SESSION['user_id'];

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $service_date = $_POST['service_date'];
        $client_name = $_POST['client_name'];
        $mother_name = $_POST['mother_name'];
        $date_of_birth = $_POST['date_of_birth'];
        $price = floatval($_POST['price']);
        $office_fee = floatval($_POST['office_fee']);
        $agent_name = $_POST['agent_name'];
        $currency = $_POST['currency'];
        $notes = $_POST['notes'] ?? '';
        $payment_status = $_POST['payment_status'];
        
        $sql = "INSERT INTO go_home_service (
                    service_date, client_name, mother_name, date_of_birth, 
                    price, office_fee, agent_name, currency, notes, 
                    payment_status, created_by
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        
        $stmt = $conn->prepare($sql);
        $stmt->bind_param(
            "ssssddsssss",
            $service_date,
            $client_name,
            $mother_name,
            $date_of_birth,
            $price,
            $office_fee,
            $agent_name,
            $currency,
            $notes,
            $payment_status,
            $user_id
        );
        
        if ($stmt->execute()) {
            $_SESSION['success_message'] = "Go Home service has been successfully added.";
            header('Location: all_go_home.php');
            exit();
        } else {
            $_SESSION['error_message'] = "Error adding Go Home service: " . $stmt->error;
        }
    } catch (Exception $e) {
        $_SESSION['error_message'] = "Error: " . $e->getMessage();
    }
}
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Add Go Home Service')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Services', 'title' => 'Add Go Home Service')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Go Home Service Details</h4>
                                </div>
                                <div class="card-body">
                                    <form action="" method="POST" class="needs-validation" novalidate>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="service_date">Service Date</label>
                                                    <input type="date" class="form-control" id="service_date" name="service_date" 
                                                           value="<?php echo date('Y-m-d'); ?>" required>
                                                    <div class="invalid-feedback">
                                                        Please enter service date.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="client_name">Client Name</label>
                                                    <input type="text" class="form-control" id="client_name" name="client_name" required>
                                                    <div class="invalid-feedback">
                                                        Please enter client name.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="mother_name">Mother's Name</label>
                                                    <input type="text" class="form-control" id="mother_name" name="mother_name" required>
                                                    <div class="invalid-feedback">
                                                        Please enter mother's name.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="date_of_birth">Date of Birth</label>
                                                    <input type="date" class="form-control" id="date_of_birth" name="date_of_birth" required>
                                                    <div class="invalid-feedback">
                                                        Please enter date of birth.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="price">Price</label>
                                                    <input type="number" class="form-control" id="price" name="price" 
                                                           step="0.01" min="0" required>
                                                    <div class="invalid-feedback">
                                                        Please enter price.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="office_fee">Office Fee</label>
                                                    <input type="number" class="form-control" id="office_fee" name="office_fee" 
                                                           step="0.01" min="0" required>
                                                    <div class="invalid-feedback">
                                                        Please enter office fee.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="agent_name">Agent Name</label>
                                                    <input type="text" class="form-control" id="agent_name" name="agent_name" required>
                                                    <div class="invalid-feedback">
                                                        Please enter agent name.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="currency">Currency</label>
                                                    <select class="form-select" id="currency" name="currency" required>
                                                        <option value="">Select currency</option>
                                                        <option value="USD" selected>USD</option>
                                                        <option value="KES">KES</option>
                                                    </select>
                                                    <div class="invalid-feedback">
                                                        Please select currency.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label" for="payment_status">Payment Status</label>
                                                    <select class="form-select" id="payment_status" name="payment_status" required>
                                                        <option value="">Select payment status</option>
                                                        <option value="unpaid">Unpaid</option>
                                                        <option value="partial">Partial</option>
                                                        <option value="paid">Paid</option>
                                                    </select>
                                                    <div class="invalid-feedback">
                                                        Please select payment status.
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div class="mb-3">
                                                    <label class="form-label" for="notes">Notes (Optional)</label>
                                                    <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mt-3">
                                            <button type="submit" class="btn btn-primary">Submit</button>
                                            <a href="all_go_home.php" class="btn btn-secondary">Cancel</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
    <script>
        // Form validation
        (function() {
            'use strict';
            window.addEventListener('load', function() {
                var forms = document.getElementsByClassName('needs-validation');
                var validation = Array.prototype.filter.call(forms, function(form) {
                    form.addEventListener('submit', function(event) {
                        if (form.checkValidity() === false) {
                            event.preventDefault();
                            event.stopPropagation();
                        }
                        form.classList.add('was-validated');
                    }, false);
                });
            }, false);
        })();
    </script>
</body>
</html>