<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>

<?php
// Include the database connection file
include 'layouts/dbconn.php';

// Fetch airports data from the database
$query = "SELECT airport_id, airport_name FROM airports";
$result = $conn->query($query);

// Initialize an array to store airport data
$airports = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $airports[] = $row; // Store each row in the $airports array
    }
}

// Close the database connection
$conn->close();
?>


<head>

    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Add Flight')); ?>
    
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <?php include 'layouts/head-css.php'; ?>

</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">

        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Manage Flights', 'title' => 'Add Flight')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Add Flight</h4>
                                </div><!-- end card header -->
                                <div class="card-body">
                                    <form method="POST" action="save_flight.php">
                                        <div class="live-preview">
                                            <div class="row gy-4">
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="flightNumber" class="form-label">Flight Number</label>
                                                        <div class="form-icon">
                                                            <input type="text" class="form-control form-control-icon" id="flightNumber" name="flight_number" placeholder="OAL001" required>
                                                            <i class="ri-plane-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--end col-->
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="originAirport" class="form-label">Origin Airport</label>
                                                        <div class="form-icon">
                                                            <select class="js-example-basic-single" name="origin_id" id="originAirport" required>
                                                                <option value="">Select Origin Airport</option>
                                                                <?php foreach ($airports as $airport): ?>
                                                                    <option value="<?php echo $airport['airport_id']; ?>">
                                                                        <?php echo $airport['airport_name']; ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--end col-->
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="destinationAirport" class="form-label">Destination Airport</label>
                                                        <div class="form-icon">
                                                             <select class="js-example-basic-single" name="destination_id" id="destinationAirport" required>
                                                                <option value="">Select Destination Airport</option>
                                                                <?php foreach ($airports as $airport): ?>
                                                                    <option value="<?php echo $airport['airport_id']; ?>">
                                                                        <?php echo $airport['airport_name']; ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--end col-->
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="departureDate" class="form-label">Departure Date</label>
                                                        <div class="form-icon">
                                                            <input type="date" class="form-control form-control-icon" id="departureDate" name="departure_date" required>
                                                            <i class="ri-map-pin-time-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="departureTime" class="form-label">Departure Time</label>
                                                        <div class="form-icon">
                                                            <input type="time" class="form-control form-control-icon" id="departureTime" name="departure_time" required>
                                                            <i class="ri-map-pin-time-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--end col-->
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="arrivalDate" class="form-label">Arrival Date</label>
                                                        <div class="form-icon">
                                                            <input type="date" class="form-control form-control-icon" id="arrivalDate" name="arrival_date" required>
                                                            <i class="ri-map-pin-time-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xxl-3 col-md-6">
                                                    <div>
                                                        <label for="arrivalTime" class="form-label">Arrival Time</label>
                                                        <div class="form-icon">
                                                            <input type="time" class="form-control form-control-icon" id="arrivalTime" name="arrival_time" required>
                                                            <i class="ri-map-pin-time-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--end col-->
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="flightPrice" class="form-label">Flight Price</label>
                                                        <div class="form-icon">
                                                            <input type="text" class="form-control form-control-icon" id="flightPrice" name="price" placeholder="1000.00" required>
                                                            <i class="ri-money-dollar-circle-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--end col-->
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                        <label for="availableSeats" class="form-label">Available Seats</label>
                                                        <div class="form-icon">
                                                            <input type="number" class="form-control form-control-icon" id="availableSeats" name="available_seats" placeholder="50" required>
                                                            <i class="ri-seat-line"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--end col-->
                                                <div class="col-xxl-4 col-md-6">
                                                    <!-- Empty Column for Alignment -->
                                                </div>
                                                <div class="col-xxl-4 col-md-6">
                                                    <div>
                                                       <button type="submit" class="btn btn-success btn-label waves-effect waves-light rounded-pill">
                                                           <i class="ri-check-double-line label-icon align-middle rounded-pill fs-16 me-2"></i> Save
                                                       </button>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--end row-->
                                        </div>
                                    </form>

                                    
                                </div>
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <!--end row-->


                </div> <!-- container-fluid -->
            </div><!-- End Page-content -->

            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/vendor-scripts.php'; ?>

    <!-- prismjs plugin -->
    <script src="assets/libs/prismjs/prism.js"></script>

    <script src="assets/js/app.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <!--select2 cdn-->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="assets/js/pages/select2.init.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Initialize Select2 on both dropdowns
    $('#originAirport').select2();
    $('#destinationAirport').select2();

    // Get both dropdowns
    const originSelect = document.getElementById('originAirport');
    const destinationSelect = document.getElementById('destinationAirport');

    // Ensure both dropdown elements are present
    if (!originSelect || !destinationSelect) return;

    // Helper function to disable the selected option in the opposite dropdown
    function disableSelectedOption(selectElement, valueToDisable) {
        Array.from(selectElement.options).forEach(option => {
            option.disabled = option.value === valueToDisable;
        });

        // Refresh Select2 to reflect changes
        $('#' + selectElement.id).select2();
    }

    // Function to check for duplicate selections and reset if necessary
    function checkForDuplicates() {
        const selectedOrigin = originSelect.value;
        const selectedDestination = destinationSelect.value;

        if (selectedOrigin === selectedDestination && selectedOrigin !== "") {
            alert("Origin and Destination cannot be the same. Please select a different option.");
            destinationSelect.value = "";
            $('#destinationAirport').val("").trigger('change');
        }
    }

    // Event listener for Origin dropdown changes
    $('#originAirport').on('change', function () {
        const selectedOrigin = originSelect.value;

        // Reset all options in the Destination dropdown
        Array.from(destinationSelect.options).forEach(option => option.disabled = false);

        // Disable the selected origin airport in the destination dropdown
        if (selectedOrigin) {
            disableSelectedOption(destinationSelect, selectedOrigin);
        }

        // Check for duplicates after processing
        checkForDuplicates();
    });

    // Event listener for Destination dropdown changes
    $('#destinationAirport').on('change', function () {
        const selectedDestination = destinationSelect.value;

        // Reset all options in the Origin dropdown
        Array.from(originSelect.options).forEach(option => option.disabled = false);

        // Disable the selected destination airport in the origin dropdown
        if (selectedDestination) {
            disableSelectedOption(originSelect, selectedDestination);
        }

        // Check for duplicates after processing
        checkForDuplicates();
    });
});

</script>


</body>

</html>