<?php
include 'layouts/session.php';
include 'layouts/dbconn.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    try {
        $conn->begin_transaction();
        
        $booking_id = $_POST['booking_id'];
        $cancellation_reason = $_POST['cancellation_reason'];
        $refund_amount = $_POST['refund_amount'];
        $refund_date = $_POST['refund_date'] ? $_POST['refund_date'] : null;
        
        $stmt = $conn->prepare("UPDATE bookings SET 
            cancellation_reason = ?,
            refund_amount = ?,
            refund_date = ?
            WHERE booking_id = ? AND status = 'Cancelled'");
            
        $stmt->bind_param("sdsi", 
            $cancellation_reason,
            $refund_amount,
            $refund_date,
            $booking_id
        );
        
        $stmt->execute();
        
        $conn->commit();
        $_SESSION['success_msg'] = "Cancellation details updated successfully";
        
    } catch (Exception $e) {
        $conn->rollback();
        $_SESSION['error_msg'] = "Error updating cancellation: " . $e->getMessage();
    }
    
    header("Location: view_cancellation.php?id=" . $booking_id);
    exit();
}

header("Location: all_cancellations.php");
exit();
?>