<?php
// Set role_id if missing but user_role exists
if (empty($_SESSION['role_id']) && isset($_SESSION['user_role'])) {
    $role_map = [
        'admin' => 1,
        'general_manager' => 2,
        'operations' => 3,
        'finance' => 4,
        'declaration_officer' => 5,
        'shipping_line_clerk' => 6,
        'transport_supervisor' => 7
    ];
    
    $_SESSION['role_id'] = $role_map[$_SESSION['user_role']] ?? null;
    error_log("Role ID mapped from user_role: " . $_SESSION['role_id']);
}

// Fallback query to get role_id if it's still missing
if (!isset($_SESSION['role_id']) && isset($_SESSION['user_id'])) {
    include_once 'dbconn.php'; // Adjust path if needed
    
    $user_id = $_SESSION['user_id'];
    $sql = "SELECT ur.role_id FROM user_roles ur WHERE ur.user_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $_SESSION['role_id'] = $row['role_id'];
        error_log("Role ID retrieved from database: " . $_SESSION['role_id']);
    }
    $stmt->close();
}

// Modified hasRole function that only takes one parameter (allowed roles)
function hasRole($allowed_roles) {
    // Check numeric role_id
    if (isset($_SESSION['role_id']) && !empty($_SESSION['role_id'])) {
        return in_array($_SESSION['role_id'], $allowed_roles);
    }
    
    // Map text role to numeric ID when role_id is missing
    if (isset($_SESSION['user_role'])) {
        $role_map = [
            'admin' => 1,
            'general_manager' => 2,
            'operations' => 3,
            'finance' => 4,
            'declaration_officer' => 5,
            'shipping_line_clerk' => 6,
            'transport_supervisor' => 7
        ];
        
        $mapped_role_id = $role_map[$_SESSION['user_role']] ?? null;
        if ($mapped_role_id) {
            return in_array($mapped_role_id, $allowed_roles);
        }
    }
    
    return false;
}
?>

<!-- ========== App Menu ========== -->
<div class="app-menu navbar-menu">
    <!-- LOGO -->
    <div class="navbar-brand-box">
        <!-- Dark Logo-->
        <a href="index.php" class="logo logo-dark">
            <span class="logo-sm">
                <img src="assets/images/logo-rf.png" alt="" height="40">
            </span>
            <span class="logo-lg">
                <img src="assets/images/logo-rf.png" alt="" height="40">
            </span>
        </a>
        <!-- Light Logo-->
        <a href="index.php" class="logo logo-light">
            <span class="logo-sm">
                <img src="assets/images/logo-rf.png" alt="" height="40">
            </span>
            <span class="logo-lg">
                <img src="assets/images/logo-rf.png" alt="" height="40">
            </span>
        </a>
        <button type="button" class="btn btn-sm p-0 fs-20 header-item float-end btn-vertical-sm-hover" id="vertical-hover">
            <i class="ri-record-circle-line"></i>
        </button>
    </div>

    <div id="scrollbar">
        <div class="container-fluid">
            <div id="two-column-menu"></div>
            <ul class="navbar-nav" id="navbar-nav">
               <!-- Dashboard - Visible to all but with different destinations -->
                <li class="menu-title"><span data-key="t-menu">Menu</span></li>
                <li class="nav-item">
                    <?php
                    if (hasRole([1, 2, 3])) {
                        $dashboardLink = "index.php";
                    } else {
                        $dashboardLink = "dashboard.php";
                    }
                    ?>
                    <a class="nav-link menu-link" href="<?php echo $dashboardLink; ?>">
                        <i class="ri-dashboard-2-line"></i> <span data-key="t-dashboards">Dashboard</span>
                    </a>
                </li>

                <?php if (hasRole([1, 2, 3, 4, 5])): // Admin, GM, Operations, Employee ?>
                <!-- Shipment Management -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-cargo">Shipment Management</span></li>
                <li class="nav-item">
                    <a href="local_shipment.php" class="nav-link">
                        <i class="ri-ticket-2-line"></i> <span>New Local Shipment</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="file_list.php" class="nav-link">
                        <i class="ri-file-list-3-line"></i> <span>View All Shipments</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="transit_shipment.php" class="nav-link">
                        <i class="ri-passport-line"></i> <span>New Transit Shipment</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="add_file_payment.php" class="nav-link">
                        <i class="ri-close-circle-line"></i> <span>Add Shipment Payments</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="import_shipment.php" class="nav-link">
                        <i class="ri-close-circle-line"></i> <span>Import Shipments</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="truck_list.php" class="nav-link">
                        <i class="ri-close-circle-line"></i> <span>Truck Assignment List</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="truck_reassignments.php" class="nav-link">
                        <i class="ri-close-circle-line"></i> <span>Truck Reassignment</span>
                    </a>
                </li>
                <?php endif; ?>
                
                <?php if (hasRole([1, 2, 3, 4])): // Admin, GM, Operations ?>
                <!-- Delivery & Returns Management -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-customer">Delivery & Returns</span></li>
                <li class="nav-item">
                    <a href="container_deposit_refund.php" class="nav-link">
                        <i class="ri-contacts-fill"></i> <span>Deposit Refunds</span>
                    </a>
                </li>
                <!-- Add this where appropriate in your menu structure -->
                <?php if (hasRole([1])): // If user is admin ?>
                <li class="nav-item">
                    <a class="nav-link menu-link" href="refund_approvals.php">
                        <i class="ri-secure-payment-line"></i> <span>Refund Approvals</span>
                        <?php
                        // Get count of pending approvals
                        $query_pending = "SELECT COUNT(*) as count FROM container_deposit WHERE status = 'Pending' AND refund_amount > 0";
                        $result_pending = $conn->query($query_pending);
                        $pending_count = 0;
                        
                        if ($result_pending && $row_pending = $result_pending->fetch_assoc()) {
                            $pending_count = $row_pending['count'];
                        }
                        
                        if ($pending_count > 0):
                        ?>
                        <span class="badge bg-danger rounded-pill ms-auto"><?php echo $pending_count; ?></span>
                        <?php endif; ?>
                    </a>
                </li>
                <?php endif; ?>
                <li class="nav-item">
                    <a href="delivery_returns.php" class="nav-link">
                        <i class="ri-contacts-fill"></i> <span>Delivery Returns</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="update_container_remarks.php" class="nav-link">
                        <i class="ri-contacts-fill"></i> <span>Update Remarks</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="container_depo_list.php" class="nav-link">
                        <i class="ri-user-add-line"></i> <span>Deposit List</span>
                    </a>
                </li>
                
                
                
                <?php if (hasRole([1, 2])): // Admin, GM only ?>
                <li class="nav-item">
                    <a class="nav-link menu-link" href="container_refund_list.php">
                        <i class="ri-refund-2-line"></i> <span>Deposit Refunds</span>
                    </a>
                </li>
                <?php endif; ?>
                
                <?php endif; ?>
                
                <?php if (hasRole([1, 2, 3, 4])): // Admin, GM, Operations ?>
                <!-- Customer Management -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-customer">Customers Management</span></li>
                <li class="nav-item">
                    <a href="all_customers.php" class="nav-link">
                        <i class="ri-contacts-fill"></i> <span>View All Customers</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="add_customer.php" class="nav-link">
                        <i class="ri-user-add-line"></i> <span>Add New Customer</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="client_debt_list.php" class="nav-link">
                        <i class="ri-user-add-line"></i> <span>Client Debt List</span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if (hasRole([1, 2])): // Admin, GM ?>
                <!-- User Management -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-user">User Management</span></li>
                <li class="nav-item">
                    <a href="all_users.php" class="nav-link">
                        <i class="ri-group-line"></i> <span>View All Users</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="add_user.php" class="nav-link">
                        <i class="ri-user-add-line"></i> <span>Add New User</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="all_roles.php" class="nav-link">
                        <i class="ri-user-add-line"></i> <span>All User Roles</span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if (hasRole([1, 2, 4])): // Admin, GM, Finance ?>
                <!-- Payments & Invoicing ,-->
                <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-payment">Payments & Invoicing</span></li>
                <li class="nav-item">
                    <a href="all_in_list.php" class="nav-link">
                        <i class="ri-currency-line"></i> <span>All In List</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="approve_all_in.php" class="nav-link">
                        <i class="ri-currency-line"></i> <span>All In Approval</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="#" class="nav-link">
                        <i class="ri-money-dollar-circle-line"></i> <span>Add New Payment</span>
                    </a>
                </li>
                 <li class="nav-item">
                    <a href="view_pre_proforma_totals.php" class="nav-link">
                        <i class="ri-money-dollar-circle-line"></i> <span>Pre Proforma Totals</span>
                    </a>
                </li>
                 <li class="nav-item">
                    <a href="view_proforma_totals.php" class="nav-link">
                        <i class="ri-money-dollar-circle-line"></i> <span>Proforma Totals</span>
                    </a>
                </li>
                
                <!-- Expense Management -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span>Expense Management</span></li>
                <li class="nav-item">
                    <a href="expense_list.php" class="nav-link">
                        <i class="ri-funds-line"></i> <span>View All Expenses</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="capture_expense.php" class="nav-link">
                        <i class="ri-add-circle-line"></i> <span>Add New Expense</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="fund_request.php" class="nav-link">
                        <i class="ri-add-circle-line"></i> <span>Add New Fund Request</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="fund_request_list.php" class="nav-link">
                        <i class="ri-funds-line"></i> <span>View All Requests</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="cheque_withdrawals.php" class="nav-link">
                        <i class="ri-funds-line"></i> <span>View All Withdrawals</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="deposit_list.php" class="nav-link">
                        <i class="ri-funds-line"></i> <span>View All Deposits</span>
                    </a>
                </li>
                <?php endif; ?>
                
                <li class="menu-title"><i class="ri-more-fill"></i> <span>Document Management</span></li>
                <li class="nav-item">
                    <a href="file_manager.php" class="nav-link">
                        <i class="ri-funds-line"></i> <span>All Files</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="file_manager.php?filter=recent" class="nav-link">
                        <i class="ri-add-circle-line"></i> <span>Recent Files</span>
                    </a>
                </li>

                <?php if (hasRole([1, 2, 4])): // Admin, GM, Finance ?>
                <!-- Reports & Analytics -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span>Reports & Analytics</span></li>
                <li class="nav-item">
                    <a href="container_deposit_report.php" class="nav-link">
                        <i class="ri-safe-line"></i> <span>Container Deposits</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="financial_report.php" class="nav-link">
                        <i class="ri-pie-chart-2-line"></i> <span>Financial Reports</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="operational_report.php" class="nav-link">
                        <i class="ri-bar-chart-box-line"></i> <span>Operational Reports</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="cargo_manifest.php" class="nav-link">
                        <i class="ri-file-chart-line"></i> <span>Cargo Manifest Reports</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="agency_earnings.php" class="nav-link">
                        <i class="ri-line-chart-line"></i> <span>Agency Earnings Report</span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if (hasRole([1, 2])): // Admin, GM only ?>
                <!-- System Settings -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span>System Settings</span></li>
                <li class="nav-item">
                    <a href="settings.php" class="nav-link">
                        <i class="ri-settings-5-line"></i> <span>General Settings</span>
                    </a>
                </li>
                 <li class="nav-item">
                        <a href="backup.php" class="nav-link">
                            <i class="ri-database-2-line"></i> <span>Backup & Restore</span>
                        </a>
                    </li>
                <li class="nav-item">
                        <a href="expense_categories.php" class="nav-link">
                            <i class="ri-database-2-line"></i> <span>Expense Categories</span>
                        </a>
                    </li>    
                <li class="nav-item">
                    <a href="audit_logs.php" class="nav-link">
                        <i class="ri-history-line"></i> <span>Audit Logs</span>
                    </a>
                </li>
                 <li class="nav-item">
                    <a href="delete_record.php" class="nav-link">
                        <i class="ri-history-line"></i> <span>Delete Records</span>
                    </a>
                </li>
                <?php endif; ?>
                <li class="nav-item">
                    <a href="my_tickets.php" class="nav-link">
                        <i class="ri-history-line"></i> <span>Support Tickets</span>
                    </a>
                </li>
                <!-- Add a divider before logout -->
                <li class="menu-title"><i class="ri-more-fill"></i> <span>Account</span></li>
                
                <!-- Logout link - visible to all users -->
                <li class="nav-item">
                    <a href="logout.php" class="nav-link">
                        <i class="ri-logout-box-line"></i> <span>Logout</span>
                    </a>
                </li>
            </ul>
        </div>
    </div>
    <div class="sidebar-background"></div>
</div>
<!-- Left Sidebar End -->
<!-- Vertical Overlay-->
<div class="vertical-overlay"></div>