<?php
session_start();
include 'layouts/dbconn.php';
require_once 'ShipmentImporter.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Initialize importer
$importer = new ShipmentImporter($conn);

// Handle template download
if (isset($_GET['download_template'])) {
    $importer->generateTemplate();
    exit();
}

// Handle file upload
if (isset($_FILES['import_file'])) {
    $uploadedFile = $_FILES['import_file']['tmp_name'];
    try {
        $importResults = $importer->importData($uploadedFile);
        $_SESSION['import_data'] = $importResults['data'];
        $_SESSION['import_errors'] = $importResults['errors'];
        header('Location: verify_import.php');
        exit();
    } catch (Exception $e) {
        $_SESSION['error_message'] = "Import failed: " . $e->getMessage();
    }
}

include 'layouts/main.php';
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Import Shipments')); ?>
    <?php include 'layouts/head-css.php'; ?>
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Shipments', 'title' => 'Import Shipments')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Import Shipments</h4>
                                </div>
                                <div class="card-body">
                                    <?php if (isset($_SESSION['error_message'])): ?>
                                        <div class="alert alert-danger">
                                            <?php 
                                            echo $_SESSION['error_message'];
                                            unset($_SESSION['error_message']);
                                            ?>
                                        </div>
                                    <?php endif; ?>

                                    <div class="row mb-4">
                                        <div class="col-12">
                                            <a href="?download_template=1" class="btn btn-primary">
                                                <i class="ri-download-2-line align-bottom me-1"></i> 
                                                Download Import Template
                                            </a>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-8">
                                            <form action="" method="post" enctype="multipart/form-data" class="row g-3">
                                                <div class="col-12">
                                                    <label for="import_file" class="form-label">Select Excel File</label>
                                                    <input type="file" class="form-control" id="import_file" name="import_file" 
                                                           accept=".xlsx,.xls" required>
                                                </div>
                                                <div class="col-12">
                                                    <button type="submit" class="btn btn-success">
                                                        <i class="ri-upload-2-line align-bottom me-1"></i> 
                                                        Upload and Verify
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
</body>
</html>