<?php
include 'layouts/dbconn.php';

$search = isset($_GET['q']) ? $_GET['q'] : '';
$query = "SELECT customer_id, first_name, last_name, phone_number FROM customers WHERE first_name LIKE ? OR last_name LIKE ? OR phone_number LIKE ?";
$stmt = $conn->prepare($query);
$searchTerm = '%' . $search . '%';
$stmt->bind_param('sss', $searchTerm, $searchTerm, $searchTerm);
$stmt->execute();
$result = $stmt->get_result();

$customers = [];
while ($row = $result->fetch_assoc()) {
    $customers[] = [
        'id' => $row['customer_id'],
        'text' => $row['first_name'] . ' ' . $row['last_name'],
        'first_name' => $row['first_name'],
        'last_name' => $row['last_name'],
        'phone_number' => $row['phone_number']
    ];
}

echo json_encode($customers);

$conn->close();
?>
