<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>

<?php
// Include the database connection file
include 'layouts/dbconn.php';

// Get the booking number from the URL
$booking_number = isset($_GET['booking_number']) ? $_GET['booking_number'] : '';

// Fetch cargo details from the database
$query = "
    SELECT
        cb.*,
        sc.first_name AS sender_first_name,
        sc.last_name AS sender_last_name,
        sc.email AS sender_email,
        sc.phone_number AS sender_phone,
        sca.street_address AS sender_street_address,
        sca.city AS sender_city,
        sca.state AS sender_state,
        sca.postal_code AS sender_postal_code,
        sca.country AS sender_country,
        rc.first_name AS receiver_first_name,
        rc.last_name AS receiver_last_name,
        rc.email AS receiver_email,
        rc.phone_number AS receiver_phone,
        rca.street_address AS receiver_street_address,
        rca.city AS receiver_city,
        rca.state AS receiver_state,
        rca.postal_code AS receiver_postal_code,
        rca.country AS receiver_country
    FROM
        cargo_bookings cb
    LEFT JOIN
        customers sc ON cb.sender_customer_id = sc.customer_id
    LEFT JOIN
        customer_addresses sca ON cb.sender_address_id = sca.address_id
    LEFT JOIN
        customers rc ON cb.receiver_customer_id = rc.customer_id
    LEFT JOIN
        customer_addresses rca ON cb.receiver_address_id = rca.address_id
    WHERE
        cb.booking_number = ?
";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $booking_number);
$stmt->execute();
$result = $stmt->get_result();
$cargoDetails = $result->fetch_assoc();

// Check if cargo details were found
if (!$cargoDetails) {
    $_SESSION['error_message'] = 'Cargo details not found.';
    header("Location: cargo_bookings.php");
    exit();
}
?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'View Cargo')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body>
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Manage Cargo', 'title' => 'View Cargo')); ?>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Cargo Details</h4>
                                    <div class="flex-shrink-0">
                                        <a href="print_cargo_label.php?booking_number=<?php echo $booking_number; ?>" 
                                           target="_blank" 
                                           class="btn btn-primary">
                                            <i class="ri-printer-fill align-bottom me-1"></i> Print Label
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="live-preview">
                                        <div class="row gy-4">
                                            <!-- Cargo Tracking Code -->
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="bookingNumber" class="form-label">Cargo Tracking Code</label>
                                                    <input type="text" class="form-control" id="bookingNumber" value="<?php echo $cargoDetails['booking_number']; ?>" readonly>
                                                </div>
                                            </div>

                                            <!-- Total Amount -->
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="totalAmount" class="form-label">Total Amount</label>
                                                    <input type="text" class="form-control" id="totalAmount" value="<?php echo $cargoDetails['total_amount']; ?>" readonly>
                                                </div>
                                            </div>

                                            <!-- Payment Status -->
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="paymentStatus" class="form-label">Payment Status</label>
                                                    <input type="text" class="form-control" id="paymentStatus" value="<?php echo $cargoDetails['payment_status']; ?>" readonly>
                                                </div>
                                            </div>

                                            <!-- Paid Amount -->
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="paidAmount" class="form-label">Paid Amount</label>
                                                    <input type="text" class="form-control" id="paidAmount" value="<?php echo $cargoDetails['paid_amount']; ?>" readonly>
                                                </div>
                                            </div>

                                            <!-- Sender Information -->
                                            <div class="col-12 mt-4">
                                                <h5 class="text-muted mb-3">Sender Information</h5>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="senderName" class="form-label">Sender Name</label>
                                                    <input type="text" class="form-control" id="senderName" value="<?php echo $cargoDetails['sender_first_name'] . ' ' . $cargoDetails['sender_last_name']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="senderPhone" class="form-label">Sender Phone</label>
                                                    <input type="text" class="form-control" id="senderPhone" value="<?php echo $cargoDetails['sender_phone']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="senderEmail" class="form-label">Sender Email</label>
                                                    <input type="text" class="form-control" id="senderEmail" value="<?php echo $cargoDetails['sender_email']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="senderAddress" class="form-label">Sender Address</label>
                                                    <input type="text" class="form-control" id="senderAddress" value="<?php echo $cargoDetails['sender_street_address'] . ', ' . $cargoDetails['sender_city'] . ', ' . $cargoDetails['sender_state'] . ', ' . $cargoDetails['sender_postal_code'] . ', ' . $cargoDetails['sender_country']; ?>" readonly>
                                                </div>
                                            </div>

                                            <!-- Receiver Information -->
                                            <div class="col-12 mt-4">
                                                <h5 class="text-muted mb-3">Receiver Information</h5>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="receiverName" class="form-label">Receiver Name</label>
                                                    <input type="text" class="form-control" id="receiverName" value="<?php echo $cargoDetails['receiver_first_name'] . ' ' . $cargoDetails['receiver_last_name']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="receiverPhone" class="form-label">Receiver Phone</label>
                                                    <input type="text" class="form-control" id="receiverPhone" value="<?php echo $cargoDetails['receiver_phone']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="receiverEmail" class="form-label">Receiver Email</label>
                                                    <input type="text" class="form-control" id="receiverEmail" value="<?php echo $cargoDetails['receiver_email']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="receiverAddress" class="form-label">Receiver Address</label>
                                                    <input type="text" class="form-control" id="receiverAddress" value="<?php echo $cargoDetails['receiver_street_address'] . ', ' . $cargoDetails['receiver_city'] . ', ' . $cargoDetails['receiver_state'] . ', ' . $cargoDetails['receiver_postal_code'] . ', ' . $cargoDetails['receiver_country']; ?>" readonly>
                                                </div>
                                            </div>

                                            <!-- Cargo Details -->
                                            <div class="col-12 mt-4">
                                                <h5 class="text-muted mb-3">Cargo Details</h5>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="cargoType" class="form-label">Cargo Type</label>
                                                    <input type="text" class="form-control" id="cargoType" value="<?php echo $cargoDetails['cargo_type']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="weight" class="form-label">Weight (kg)</label>
                                                    <input type="text" class="form-control" id="weight" value="<?php echo $cargoDetails['weight']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="dimensions" class="form-label">Dimensions (L x W x H cm)</label>
                                                    <input type="text" class="form-control" id="dimensions" value="<?php echo $cargoDetails['dimensions']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div>
                                                    <label for="specialInstructions" class="form-label">Special Instructions</label>
                                                    <textarea class="form-control" id="specialInstructions" rows="3" readonly><?php echo $cargoDetails['special_instructions']; ?></textarea>
                                                </div>
                                            </div>

                                            <!-- Delivery Details -->
                                            <div class="col-12 mt-4">
                                                <h5 class="text-muted mb-3">Delivery Details</h5>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="pickupDate" class="form-label">Pickup Date & Time</label>
                                                    <input type="text" class="form-control" id="pickupDate" value="<?php echo $cargoDetails['pickup_date']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="estimatedDeliveryDate" class="form-label">Estimated Delivery Date</label>
                                                    <input type="text" class="form-control" id="estimatedDeliveryDate" value="<?php echo $cargoDetails['estimated_delivery_date']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="actualDeliveryDate" class="form-label">Actual Delivery Date</label>
                                                    <input type="text" class="form-control" id="actualDeliveryDate" value="<?php echo $cargoDetails['actual_delivery_date']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="bookingStatus" class="form-label">Booking Status</label>
                                                    <input type="text" class="form-control" id="bookingStatus" value="<?php echo $cargoDetails['booking_status']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="deliveryAttempts" class="form-label">Delivery Attempts</label>
                                                    <input type="text" class="form-control" id="deliveryAttempts" value="<?php echo $cargoDetails['delivery_attempts']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="lastAttemptDate" class="form-label">Last Attempt Date</label>
                                                    <input type="text" class="form-control" id="lastAttemptDate" value="<?php echo $cargoDetails['last_attempt_date']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="lastStatusUpdate" class="form-label">Last Status Update</label>
                                                    <input type="text" class="form-control" id="lastStatusUpdate" value="<?php echo $cargoDetails['last_status_update']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-6">
                                                <div>
                                                    <label for="lastStatusUpdateBy" class="form-label">Last Status Update By</label>
                                                    <input type="text" class="form-control" id="lastStatusUpdateBy" value="<?php echo $cargoDetails['last_status_update_by']; ?>" readonly>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div>
                                                    <label for="statusNotes" class="form-label">Status Notes</label>
                                                    <textarea class="form-control" id="statusNotes" rows="3" readonly><?php echo $cargoDetails['status_notes']; ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->
    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/vendor-scripts.php'; ?>

    <!-- prismjs plugin -->
    <script src="assets/libs/prismjs/prism.js"></script>
    <script src="assets/js/app.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            <?php if (isset($_SESSION['success_message'])): ?>
                Swal.fire({
                    title: 'Success!',
                    text: '<?php echo addslashes($_SESSION['success_message']); ?>',
                    icon: 'success',
                    confirmButtonClass: 'btn btn-primary w-xs mt-2',
                    buttonsStyling: false
                });
                <?php unset($_SESSION['success_message']); ?>
            <?php endif; ?>

            <?php if (isset($_SESSION['error_message'])): ?>
                Swal.fire({
                    title: 'Error!',
                    text: '<?php echo addslashes($_SESSION['error_message']); ?>',
                    icon: 'error',
                    confirmButtonClass: 'btn btn-primary w-xs mt-2',
                    buttonsStyling: false
                });
                <?php unset($_SESSION['error_message']); ?>
            <?php endif; ?>
        });
    </script>
</body>
</html>
