<?php
session_start();
include 'layouts/dbconn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Fetch all all-in requests with file details
$sql = "SELECT pa.*, f.all_in_amount as current_amount,
        u.full_name as approver_name
        FROM pending_approvals pa
        JOIN pre_proforma f ON pa.file_number = f.file_number
        LEFT JOIN users u ON u.full_name = pa.approver
        ORDER BY pa.proposed_date DESC";

$result = $conn->query($sql);
$approvals = [];
while ($row = $result->fetch_assoc()) {
    $approvals[] = $row;
}

// Set system name
$sql = "SELECT setting_value FROM settings WHERE setting_key = 'system_name'";
$result = $conn->query($sql);
$system_name = $result->num_rows > 0 ? $result->fetch_assoc()['setting_value'] : "Royal Freight";
?>

<?php include 'layouts/main.php'; ?>

<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'All In Amount List')); ?>
    <?php include 'layouts/head-css.php'; ?>
    
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css" rel="stylesheet">
    
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Files', 'title' => 'All In Amount List')); ?>

                    <?php if (isset($_SESSION['success_message'])): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php 
                                echo $_SESSION['success_message'];
                                unset($_SESSION['success_message']);
                            ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">All In Amount Requests</h4>
                                </div>
                                <div class="card-body">
                                    <table id="allInTable" class="table table-bordered dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>File Number</th>
                                                <th>Current Amount</th>
                                                <th>Proposed Amount</th>
                                                <th>Proposed By</th>
                                                <th>Proposed Date</th>
                                                <th>Status</th>
                                                <th>Approver</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($approvals as $approval): ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars($approval['file_number']); ?></td>
                                                    <td><?php echo number_format($approval['current_amount'], 2); ?></td>
                                                    <td><?php echo number_format($approval['new_all_in_amount'], 2); ?></td>
                                                    <td><?php echo htmlspecialchars($approval['proposed_by']); ?></td>
                                                    <td><?php echo date('Y-m-d H:i:s', strtotime($approval['proposed_date'])); ?></td>
                                                    <td>
                                                        <?php 
                                                            $statusClass = '';
                                                            switch($approval['approved']) {
                                                                case 'Approved':
                                                                    $statusClass = 'badge bg-success';
                                                                    break;
                                                                case 'Rejected':
                                                                    $statusClass = 'badge bg-danger';
                                                                    break;
                                                                default:
                                                                    $statusClass = 'badge bg-warning';
                                                                    break;
                                                            }
                                                        ?>
                                                        <span class="<?php echo $statusClass; ?>">
                                                            <?php echo $approval['approved']; ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo htmlspecialchars($approval['approver_name'] ?? '-'); ?></td>
                                                    <td>
                                                        <?php if ($approval['approved'] === 'Pending' && in_array($_SESSION['role_id'], [1, 2])): ?>
                                                            <a href="allin_approval.php?id=<?php echo $approval['id']; ?>" 
                                                               class="btn btn-sm btn-primary">
                                                                Review
                                                            </a>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>

    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
    
    <script>
        $(document).ready(function() {
            $('#allInTable').DataTable({
                order: [[4, 'desc']], // Sort by proposed date by default
                pageLength: 25
            });
        });
    </script>
</body>
</html>