<?php
session_start();
include '../layouts/dbconn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'Not authenticated']);
    exit();
}

// Get deposit ID
$id = $_GET['id'] ?? 0;
if (empty($id)) {
    echo '<div class="alert alert-danger">Invalid request: Missing deposit ID</div>';
    exit();
}

// Check if our columns exist
$has_created_by = false;
$has_approved_by = false;
$has_admin_remarks = false;
$has_approval_date = false;

$column_check = $conn->query("SHOW COLUMNS FROM container_deposit LIKE 'created_by'");
if ($column_check->num_rows > 0) {
    $has_created_by = true;
}

$column_check = $conn->query("SHOW COLUMNS FROM container_deposit LIKE 'approved_by'");
if ($column_check->num_rows > 0) {
    $has_approved_by = true;
}

$column_check = $conn->query("SHOW COLUMNS FROM container_deposit LIKE 'admin_remarks'");
if ($column_check->num_rows > 0) {
    $has_admin_remarks = true;
}

$column_check = $conn->query("SHOW COLUMNS FROM container_deposit LIKE 'approved_at'");
if ($column_check->num_rows > 0) {
    $has_approval_date = true;
}

// Build query based on available columns
$query = "SELECT cd.id, cd.bl, cd.shipping_line, cd.container, cd.type, 
        cd.deposit, cd.date_deposited, cd.refund_amount, cd.balance, 
        cd.refund_date, cd.remarks, cd.status";

if ($has_created_by) {
    $query .= ", u1.username as requested_by, cd.created_at";
}

if ($has_approved_by) {
    $query .= ", u2.username as approved_by";
}

if ($has_admin_remarks) {
    $query .= ", cd.admin_remarks";
}

if ($has_approval_date) {
    $query .= ", cd.approved_at";
}

$query .= " FROM container_deposit cd";

if ($has_created_by) {
    $query .= " LEFT JOIN users u1 ON cd.created_by = u1.user_id";
}

if ($has_approved_by) {
    $query .= " LEFT JOIN users u2 ON cd.approved_by = u2.user_id";
}

$query .= " WHERE cd.id = ?";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows > 0) {
    $deposit = $result->fetch_assoc();
    
    // Format status label
    $status_html = '';
    $status = $deposit['status'] ?? 'N/A';
    if ($status === 'Pending') {
        $status_html = '<span class="badge bg-warning">Pending</span>';
    } elseif ($status === 'Approved') {
        $status_html = '<span class="badge bg-success">Approved</span>';
    } elseif ($status === 'Rejected') {
        $status_html = '<span class="badge bg-danger">Rejected</span>';
    } else {
        $status_html = '<span class="badge bg-secondary">N/A</span>';
    }
    
    // Output HTML
    ?>
    <div class="row mb-4">
        <div class="col-md-6">
            <h6 class="fw-semibold">Bill of Lading (BL)</h6>
            <p><?php echo htmlspecialchars($deposit['bl']); ?></p>
        </div>
        <div class="col-md-6">
            <h6 class="fw-semibold">Container Number</h6>
            <p><?php echo htmlspecialchars($deposit['container']); ?></p>
        </div>
    </div>
    
    <div class="row mb-4">
        <div class="col-md-4">
            <h6 class="fw-semibold">Shipping Line</h6>
            <p><?php echo htmlspecialchars($deposit['shipping_line']); ?></p>
        </div>
        <div class="col-md-4">
            <h6 class="fw-semibold">Type</h6>
            <p><?php echo htmlspecialchars($deposit['type']); ?></p>
        </div>
        <div class="col-md-4">
            <h6 class="fw-semibold">Status</h6>
            <p><?php echo $status_html; ?></p>
        </div>
    </div>
    
    <div class="row mb-4">
        <div class="col-md-4">
            <h6 class="fw-semibold">Deposit Amount</h6>
            <p class="text-dark">$<?php echo number_format($deposit['deposit'], 2); ?></p>
        </div>
        <div class="col-md-4">
            <h6 class="fw-semibold">Refund Amount</h6>
            <p class="text-primary">$<?php echo number_format($deposit['refund_amount'], 2); ?></p>
        </div>
        <div class="col-md-4">
            <h6 class="fw-semibold">Remaining Balance</h6>
            <p class="text-muted">$<?php echo number_format($deposit['balance'], 2); ?></p>
        </div>
    </div>
    
    <div class="row mb-4">
        <div class="col-md-4">
            <h6 class="fw-semibold">Date Deposited</h6>
            <p><?php echo date('Y-m-d', strtotime($deposit['date_deposited'])); ?></p>
        </div>
        <div class="col-md-4">
            <h6 class="fw-semibold">Refund Date</h6>
            <p><?php echo date('Y-m-d', strtotime($deposit['refund_date'])); ?></p>
        </div>
        <?php if ($has_created_by): ?>
        <div class="col-md-4">
            <h6 class="fw-semibold">Requested By</h6>
            <p><?php echo htmlspecialchars($deposit['requested_by'] ?? 'N/A'); ?></p>
        </div>
        <?php endif; ?>
    </div>
    
    <?php if ($has_approved_by && !empty($deposit['approved_by'])): ?>
    <div class="row mb-4">
        <?php if ($has_approved_by): ?>
        <div class="col-md-6">
            <h6 class="fw-semibold">Approved By</h6>
            <p><?php echo htmlspecialchars($deposit['approved_by']); ?></p>
        </div>
        <?php endif; ?>
        
        <?php if ($has_approval_date && !empty($deposit['approved_at'])): ?>
        <div class="col-md-6">
            <h6 class="fw-semibold">Approval Date</h6>
            <p><?php echo date('Y-m-d H:i', strtotime($deposit['approved_at'])); ?></p>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>
    
    <?php if (!empty($deposit['remarks'])): ?>
    <div class="row mb-4">
        <div class="col-12">
            <h6 class="fw-semibold">Remarks</h6>
            <p><?php echo nl2br(htmlspecialchars($deposit['remarks'])); ?></p>
        </div>
    </div>
    <?php endif; ?>
    
    <?php if ($has_admin_remarks && !empty($deposit['admin_remarks'])): ?>
    <div class="row mb-4">
        <div class="col-12">
            <h6 class="fw-semibold">Admin Remarks</h6>
            <p><?php echo nl2br(htmlspecialchars($deposit['admin_remarks'])); ?></p>
        </div>
    </div>
    <?php endif; ?>
    
    <?php
} else {
    echo '<div class="alert alert-danger">Deposit record not found</div>';
}
?>