<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<?php
// Fetch all settings
$query = "SELECT * FROM settings";
$result = $conn->query($query);
$settings = array();
while ($row = $result->fetch_assoc()) {
    $settings[$row['setting_key']] = $row;
}
?>

<head>

    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'System Settings')); ?>
    
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <?php include 'layouts/head-css.php'; ?>
     <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">

        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Settings', 'title' => 'System Settings')); ?>
            
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">System Settings</h4>
                                </div>
                                <div class="card-body">
                                    <form action="save_settings.php" method="POST" enctype="multipart/form-data">
                                        <div class="row">
                                            <!-- Company Information -->
                                            <div class="col-lg-6">
                                                <div class="mb-4">
                                                    <h5 class="mb-3">Company Information</h5>
                                                    
                                                    <div class="mb-3">
                                                        <label for="system_name" class="form-label">Company Name</label>
                                                        <input type="text" class="form-control" id="system_name" 
                                                               name="settings[system_name]" 
                                                               value="<?php echo htmlspecialchars($settings['system_name']['setting_value']); ?>" required>
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="address" class="form-label">Address</label>
                                                        <textarea class="form-control" id="address" name="settings[address]" 
                                                                  rows="2"><?php echo htmlspecialchars($settings['address']['setting_value']); ?></textarea>
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="tel_1" class="form-label">Primary Phone</label>
                                                        <input type="text" class="form-control" id="tel_1" 
                                                               name="settings[tel_1]" 
                                                               value="<?php echo htmlspecialchars($settings['tel_1']['setting_value']); ?>">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="tel_2" class="form-label">Secondary Phone</label>
                                                        <input type="text" class="form-control" id="tel_2" 
                                                               name="settings[tel_2]" 
                                                               value="<?php echo htmlspecialchars($settings['tel_2']['setting_value']); ?>">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="logo" class="form-label">Company Logo</label>
                                                        <?php if (!empty($settings['logo_path']['setting_value'])): ?>
                                                            <div class="mb-2">
                                                                <img src="<?php echo $settings['logo_path']['setting_value']; ?>" 
                                                                     alt="Company Logo" class="img-thumbnail" style="max-height: 100px;">
                                                            </div>
                                                        <?php endif; ?>
                                                        <input type="file" class="form-control" id="logo" name="logo" 
                                                               accept="image/png,image/jpeg,image/jpg">
                                                        <small class="text-muted">Recommended size: 200x60 pixels</small>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- System Settings -->
                                            <div class="col-lg-6">
                                                <div class="mb-4">
                                                    <h5 class="mb-3">System Settings</h5>

                                                    <div class="mb-3">
                                                        <label for="default_currency" class="form-label">Default Currency</label>
                                                        <select class="form-select" id="default_currency" 
                                                                name="settings[default_currency]">
                                                            <option value="USD" <?php echo $settings['default_currency']['setting_value'] == 'USD' ? 'selected' : ''; ?>>USD</option>
                                                            <option value="KES" <?php echo $settings['default_currency']['setting_value'] == 'KES' ? 'selected' : ''; ?>>KES</option>
                                                        </select>
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="email_host" class="form-label">Email Host</label>
                                                        <input type="text" class="form-control" id="email_host" 
                                                               name="settings[email_host]" 
                                                               value="<?php echo htmlspecialchars($settings['email_host']['setting_value']); ?>">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="email_port" class="form-label">Email Port</label>
                                                        <input type="text" class="form-control" id="email_port" 
                                                               name="settings[email_port]" 
                                                               value="<?php echo htmlspecialchars($settings['email_port']['setting_value']); ?>">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="email_username" class="form-label">Email Username</label>
                                                        <input type="text" class="form-control" id="email_username" 
                                                               name="settings[email_username]" 
                                                               value="<?php echo htmlspecialchars($settings['email_username']['setting_value']); ?>">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="email_password" class="form-label">Email Password</label>
                                                        <input type="password" class="form-control" id="email_password" 
                                                               name="settings[email_password]" 
                                                               value="<?php echo htmlspecialchars($settings['email_password']['setting_value']); ?>">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="email_sender" class="form-label">Email Sender Name</label>
                                                        <input type="text" class="form-control" id="email_sender" 
                                                               name="settings[email_sender]" 
                                                               value="<?php echo htmlspecialchars($settings['email_sender']['setting_value']); ?>">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <button type="submit" class="btn btn-primary">Save Settings</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->

    <?php include 'layouts/vendor-scripts.php'; ?>

    <!-- prismjs plugin -->
    <script src="assets/libs/prismjs/prism.js"></script>

    <script src="assets/js/app.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <!--select2 cdn-->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="assets/js/pages/select2.init.js"></script>

</body>

</html>