<?php
include 'layouts/session.php';
include 'layouts/dbconn.php';

// Get extension details
$extension_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$sql = "SELECT pe.*, 
               u_created.full_name as created_by_name
        FROM passport_extensions pe
        LEFT JOIN users u_created ON pe.created_by = u_created.user_id
        WHERE pe.extension_id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $extension_id);
$stmt->execute();
$result = $stmt->get_result();

if (!$result->num_rows) {
    header("Location: list_extensions.php");
    exit;
}

$extension = $result->fetch_assoc();

// Get company settings
$sql = "SELECT * FROM settings WHERE setting_key IN ('system_name', 'address', 'tel_1', 'tel_2')";
$settings_result = $conn->query($sql);
$settings = [];
while ($row = $settings_result->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Passport Extension Receipt</title>
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 20px;
        }
        .receipt-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .company-details {
            margin-bottom: 20px;
        }
        .receipt-title {
            font-size: 18px;
            font-weight: bold;
            text-align: center;
            margin: 20px 0;
            text-transform: uppercase;
        }
        .section {
            margin-bottom: 20px;
        }
        .section-title {
            font-weight: bold;
            margin-bottom: 10px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }
        .info-row {
            display: flex;
            margin-bottom: 8px;
        }
        .info-label {
            font-weight: bold;
            width: 150px;
        }
        .info-value {
            flex: 1;
        }
        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 14px;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                margin: 0;
                padding: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <!-- Print Button -->
        <div class="no-print mb-3">
            <button onclick="window.print()" class="btn btn-primary">
                <i class="ri-printer-line align-middle me-1"></i> Print Receipt
            </button>
            <a href="view_extension.php?id=<?php echo $extension_id; ?>" class="btn btn-secondary">
                <i class="ri-arrow-left-line align-middle me-1"></i> Back
            </a>
        </div>

        <!-- Header -->
        <div class="header">
            <div class="company-name"><?php echo htmlspecialchars($settings['system_name']); ?></div>
            <div class="company-details">
                <?php echo htmlspecialchars($settings['address']); ?><br>
                Tel: <?php echo htmlspecialchars($settings['tel_1']); ?> / <?php echo htmlspecialchars($settings['tel_2']); ?>
            </div>
        </div>

        <div class="receipt-title">Passport Extension Receipt</div>

        <!-- Client Information -->
        <div class="section">
            <div class="section-title">Client Information</div>
            <div class="info-row">
                <div class="info-label">Client Name:</div>
                <div class="info-value"><?php echo htmlspecialchars($extension['client_name']); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Passport Number:</div>
                <div class="info-value"><?php echo htmlspecialchars($extension['passport_number']); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Country of Issue:</div>
                <div class="info-value"><?php echo htmlspecialchars($extension['country_of_issue']); ?></div>
            </div>
        </div>
        
        <!-- Service Details -->
        <div class="section">
            <div class="section-title">Service Details</div>
            <div class="info-row">
                <div class="info-label">Service Type:</div>
                <div class="info-value"><?php echo ucfirst(htmlspecialchars($extension['service_type'])); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Extension Date:</div>
                <div class="info-value"><?php echo date('d M Y', strtotime($extension['extension_date'])); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Validity Period:</div>
                <div class="info-value"><?php echo htmlspecialchars($extension['validity_period']); ?> months</div>
            </div>
            <div class="info-row">
                <div class="info-label">Expiry Date:</div>
                <div class="info-value"><?php echo date('d M Y', strtotime($extension['expiry_date'])); ?></div>
            </div>
        </div>

        <!-- Payment Details -->
        <div class="section">
            <div class="section-title">Payment Details</div>
            <div class="info-row">
                <div class="info-label">Currency:</div>
                <div class="info-value"><?php echo htmlspecialchars($extension['currency']); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Amount Received:</div>
                <div class="info-value"><?php echo $extension['currency'] . " " . number_format($extension['amount_received'], 2); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Service Payment:</div>
                <div class="info-value"><?php echo $extension['currency'] . " " . number_format($extension['service_payment'], 2); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Agency Fee:</div>
                <div class="info-value"><?php echo $extension['currency'] . " " . number_format($extension['agency_fee'], 2); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Payment Status:</div>
                <div class="info-value"><?php echo ucfirst(htmlspecialchars($extension['payment_status'])); ?></div>
            </div>
        </div>

        <!-- Notes -->
        <?php if (!empty($extension['notes'])): ?>
        <div class="section">
            <div class="section-title">Additional Notes</div>
            <div class="info-row">
                <div class="info-value"><?php echo nl2br(htmlspecialchars($extension['notes'])); ?></div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Footer -->
        <div class="footer">
            <p>Receipt generated on <?php echo date('d M Y H:i'); ?><br>
            Generated by: <?php echo htmlspecialchars($extension['created_by_name']); ?></p>
            <p>Thank you for your business!</p>
        </div>

        <!-- Signature Section -->
        <div class="section" style="margin-top: 50px;">
            <div class="row">
                <div class="col-6">
                    <div style="border-top: 1px solid #000; margin-top: 25px; padding-top: 5px;">
                        Customer Signature
                    </div>
                </div>
                <div class="col-6 text-end">
                    <div style="border-top: 1px solid #000; margin-top: 25px; padding-top: 5px;">
                        Official Signature & Stamp
                    </div>
                </div>
            </div>
        </div>

        <!-- Terms and Conditions -->
        <div class="section" style="margin-top: 30px; font-size: 12px;">
            <div class="section-title">Terms and Conditions</div>
            <ol>
                <li>This receipt must be presented for any future queries.</li>
                <li>The agency fee is non-refundable.</li>
                <li>Extension processing times may vary based on authorities.</li>
                <li>Please ensure all provided information is accurate.</li>
            </ol>
        </div>

        <!-- Barcode/QR Code space if needed -->
        <div class="text-center" style="margin-top: 20px;">
            <small>Receipt No: <?php echo str_pad($extension['extension_id'], 6, '0', STR_PAD_LEFT); ?></small>
        </div>
    </div>

    <script>
        // Auto print when page loads
        window.onload = function() {
            // Uncomment below line to enable automatic printing
            // window.print();
        };
    </script>
</body>
</html>