<?php
spl_autoload_register(function ($class) {
    // Convert namespace to full file path
    $prefix = 'PhpSpreadsheet\\';
    $base_dir = __DIR__ . '/vendor/phpoffice/vendor/phpoffice/phpspreadsheet/src/PhpSpreadsheet/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    error_log("Attempting to load: " . $file); // Debug log

    if (file_exists($file)) {
        require $file;
        error_log("Successfully loaded: " . $file); // Debug log
    } else {
        error_log("File not found: " . $file); // Debug log
    }
});

// Also register the PhpOffice namespace
spl_autoload_register(function ($class) {
    // Convert namespace to full file path
    $prefix = 'PhpOffice\\PhpSpreadsheet\\';
    $base_dir = __DIR__ . '/vendor/phpoffice/vendor/phpoffice/phpspreadsheet/src/PhpSpreadsheet/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    error_log("Attempting to load: " . $file); // Debug log

    if (file_exists($file)) {
        require $file;
        error_log("Successfully loaded: " . $file); // Debug log
    } else {
        error_log("File not found: " . $file); // Debug log
    }
});
?>