<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>
<?php include 'layouts/dbconn.php'; ?>

<head>

    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'All Destinations')); ?>

    <!--datatable css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" />
    <!--datatable responsive css-->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" />

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">


    <?php include 'layouts/head-css.php'; ?>

</head>

<body>

    <!-- Begin page -->
    <div id="layout-wrapper">

        <?php include 'layouts/menu.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Manage Destinations', 'title' => 'All Destinations')); ?>


                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">All Destinations</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="buttons-datatables" class="display table table-bordered" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>Booking ID</th>
                                                    <th>Booking Code</th>
                                                    <th>Customer</th>
                                                    <th>Flight ID</th>
                                                    <th>Booking Date</th>
                                                    <th>Status</th>
                                                    <th>Passengers</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                // Include the database connection file
                                                include('layouts/dbconn.php');
                                                
                                                // Construct the SQL query
                                                $query = "SELECT 
                                                    b.booking_id,
                                                    b.booking_code,
                                                    c.first_name,
                                                    c.last_name,
                                                    f.flight_number,
                                                    b.booking_date,
                                                    b.status,
                                                    b.total_passengers,
                                                    (SELECT COUNT(*) FROM family_members fm WHERE fm.booking_id = b.booking_id) as family_member_count
                                                FROM 
                                                    bookings b
                                                JOIN 
                                                    customers c ON b.customer_id = c.customer_id
                                                JOIN 
                                                    flights f ON b.flight_id = f.flight_id";
                                                
                                                // Execute the query
                                                $result = $conn->query($query);
                                                
                                                // Check if there are any results
                                                if ($result->num_rows > 0) {
                                                    // Loop through the results and output each row
                                                    while ($row = $result->fetch_assoc()) {
                                                        echo "<tr ondblclick=\"openFileData('{$row['booking_id']}')\">";
                                                        echo "<td>{$row['booking_id']}</td>";
                                                        echo "<td>{$row['booking_code']}</td>";
                                                        echo "<td>{$row['first_name']} {$row['last_name']}</td>";
                                                        echo "<td>{$row['flight_number']}</td>"; 
                                                        echo "<td>{$row['booking_date']}</td>";
                                                        echo "<td>{$row['status']}</td>";
                                                        echo "<td>{$row['total_passengers']} (+" . $row['family_member_count'] . " family)</td>";
                                                        echo '<td>
                                                                <ul class="list-inline hstack gap-2 mb-0">
                                                                    <li class="list-inline-item edit" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Add Payment">
                                                                        <a href="add_pay.php?booking_id=' . $row['booking_id'] . '" class="text-muted d-inline-block">
                                                                            <i class="ri-refund-2-line fs-16"></i>
                                                                        </a>
                                                                    </li>
                                                                    <li class="list-inline-item edit" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Print Booking">
                                                                        <a href="javascript:void(0);" class="text-muted d-inline-block">
                                                                            <i class="ri-printer-line fs-16"></i>
                                                                        </a>
                                                                    </li>
                                                                    <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="View">
                                                                        <a href="booking_view.php?booking_id=' . $row['booking_id'] . '"><i class="ri-eye-fill align-bottom text-muted"></i></a>
                                                                    </li>
                                                                    <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Edit">
                                                                        <a class="edit-item-btn" href="#showModal" data-bs-toggle="modal"><i class="ri-pencil-fill align-bottom text-muted"></i></a>
                                                                    </li>
                                                                    <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Delete">
                                                                        <a class="remove-item-btn" data-bs-toggle="modal" href="#deleteRecordModal">
                                                                            <i class="ri-delete-bin-fill align-bottom text-muted"></i>
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                              </td>';
                                                        echo "</tr>";
                                                    }
                                                } else {
                                                    // If no bookings are found, output a message
                                                    echo "<tr><td colspan='7'>No bookings found</td></tr>";
                                                }
                                                
                                                // Close the database connection
                                                $conn->close();
                                                ?>
                                            </tbody>    
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!--end row-->


                    

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

            <?php include 'layouts/footer.php'; ?>
        </div>
        <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->


    <?php include 'layouts/vendor-scripts.php'; ?>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script src="assets/js/pages/datatables.init.js"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
</body>

</html>