<?php
// admin_logs.php
session_start();
include 'layouts/dbconn.php';

// Check if user is logged in and has admin role
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] != 1) {
    $_SESSION['error_message'] = "You don't have permission to access this page.";
    header('Location: index.php');
    exit();
}

// Get logs with user information
$sql = "SELECT a.*, u.username, u.full_name
        FROM admin_logs a
        JOIN users u ON a.user_id = u.user_id
        ORDER BY a.created_at DESC
        LIMIT 1000";
$result = $conn->query($sql);
?>

<?php include 'layouts/main.php'; ?>
<head>
    <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Admin Activity Logs')); ?>
    <?php include 'layouts/head-css.php'; ?>
    <link href="assets/libs/datatables/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
</head>

<body>
    <div id="layout-wrapper">
        <?php include 'layouts/menu.php'; ?>
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Administration', 'title' => 'Activity Logs')); ?>
                    
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">System Activity Logs</h5>
                                </div>
                                <div class="card-body">
                                    <table id="logs-table" class="table table-bordered dt-responsive nowrap table-striped">
                                        <thead>
                                            <tr>
                                                <th>Date & Time</th>
                                                <th>User</th>
                                                <th>Action</th>
                                                <th>Details</th>
                                                <th>IP Address</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if ($result && $result->num_rows > 0) {
                                                while ($row = $result->fetch_assoc()) {
                                                    echo "<tr>";
                                                    echo "<td>" . $row['created_at'] . "</td>";
                                                    echo "<td>" . $row['full_name'] . " (" . $row['username'] . ")</td>";
                                                    
                                                    // Highlight different actions with colors
                                                    $actionClass = '';
                                                    if (strpos($row['action'], 'delete') !== false) {
                                                        $actionClass = 'text-danger';
                                                    } elseif (strpos($row['action'], 'create') !== false) {
                                                        $actionClass = 'text-success';
                                                    } elseif (strpos($row['action'], 'update') !== false) {
                                                        $actionClass = 'text-primary';
                                                    }
                                                    
                                                    echo "<td class='" . $actionClass . "'>" . ucwords(str_replace('_', ' ', $row['action'])) . "</td>";
                                                    echo "<td>" . $row['details'] . "</td>";
                                                    echo "<td>" . $row['ip_address'] . "</td>";
                                                    echo "</tr>";
                                                }
                                            } else {
                                                echo "<tr><td colspan='5' class='text-center'>No logs found</td></tr>";
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'layouts/footer.php'; ?>
        </div>
    </div>
    <?php include 'layouts/vendor-scripts.php'; ?>
    <script src="assets/js/app.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
<link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet">
<script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#logs-table').DataTable({
                responsive: true,
                order: [[0, 'desc']] // Sort by date descending
            });
        });
    </script>
</body>
</html>